/*
 * Decompiled with CFR 0.152.
 */
package one.oth3r.directionhud.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.Objects;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import one.oth3r.directionhud.DirectionHUD;
import one.oth3r.directionhud.PacketHelper;
import one.oth3r.directionhud.common.Assets;
import one.oth3r.directionhud.common.files.playerdata.CachedPData;
import one.oth3r.directionhud.common.files.playerdata.PData;
import one.oth3r.directionhud.common.files.playerdata.PlayerData;
import one.oth3r.directionhud.common.hud.module.ModuleInstructions;
import one.oth3r.directionhud.common.template.PlayerTemplate;
import one.oth3r.directionhud.common.utils.CUtl;
import one.oth3r.directionhud.common.utils.Helper;
import one.oth3r.directionhud.common.utils.Loc;
import one.oth3r.directionhud.common.utils.ParticleType;
import one.oth3r.directionhud.common.utils.Vec;
import one.oth3r.directionhud.utils.CTxT;
import one.oth3r.directionhud.utils.Utl;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.util.RayTraceResult;

public class Player
extends PlayerTemplate {
    private org.bukkit.entity.Player player;

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Player other = (Player)obj;
        return Objects.equals(this.player, other.player);
    }

    public int hashCode() {
        return Objects.hash(this.player);
    }

    public Player() {
    }

    public Player(org.bukkit.entity.Player bukkitPlayer) {
        this.player = bukkitPlayer;
    }

    public Player(String identifier) {
        this.player = identifier.contains("-") ? Bukkit.getPlayer((UUID)UUID.fromString(identifier)) : Bukkit.getPlayer((String)identifier);
    }

    @Override
    public boolean isValid() {
        return this.player != null;
    }

    @Override
    public void performCommand(String cmd) {
        this.player.performCommand(cmd);
    }

    @Override
    public void sendMessage(CTxT message) {
        this.player.sendMessage((Component)message.b());
    }

    @Override
    public void sendActionBar(CTxT message) {
        this.player.sendActionBar((Component)message.b());
    }

    @Override
    public void displayBossBar(CTxT message) {
        DirectionHUD.getData().getBossBarManager().display(this, message);
    }

    @Override
    public void removeBossBar() {
        DirectionHUD.getData().getBossBarManager().removePlayer(this);
    }

    @Override
    public void sendPDataPackets() {
        if (DirectionHUD.getData().getClientPlayers().contains(this)) {
            Gson gson = new GsonBuilder().disableHtmlEscaping().create();
            PacketHelper.sendPacket(this, Assets.packets.PLAYER_DATA, gson.toJson((Object)this.getPData()));
        }
    }

    @Override
    public void sendHUDPackets(ModuleInstructions instructions) {
        PacketHelper.sendPacket(this, Assets.packets.HUD, Helper.getGson().toJson((Object)instructions));
    }

    @Override
    public String getName() {
        return this.player.getName();
    }

    @Override
    public PData getPData() {
        return PlayerData.getPData(this);
    }

    @Override
    public CachedPData getPCache() {
        return PlayerData.getPCache(this);
    }

    @Override
    public String getUUID() {
        return this.player.getUniqueId().toString();
    }

    @Override
    public String getSpawnDimension() {
        if (this.player.getRespawnLocation() != null && this.player.getRespawnLocation().getWorld() != null) {
            return Utl.dim.format(this.player.getRespawnLocation().getWorld());
        }
        return Utl.dim.format((World)Bukkit.getWorlds().get(0));
    }

    @Override
    public String getDimension() {
        return Utl.dim.format(this.player.getWorld());
    }

    @Override
    public int getTimeOfDay() {
        return (int)this.player.getWorld().getTime() % 24000;
    }

    @Override
    public long getWorldTime() {
        return this.player.getWorld().getTime();
    }

    @Override
    public boolean hasStorm() {
        return this.player.getWorld().hasStorm();
    }

    @Override
    public boolean hasThunderstorm() {
        return this.player.getWorld().isThundering();
    }

    @Override
    public int[] getLightLevels(boolean lookTarget) {
        Object location = this.player.getLocation();
        if (lookTarget) {
            BlockFace face;
            Block block;
            RayTraceResult result = this.player.rayTraceBlocks(5.0);
            location = result != null && result.getHitBlock() != null ? (!(block = result.getHitBlock()).isPassable() ? ((face = result.getHitBlockFace()) == null ? null : block.getRelative(face).getLocation()) : block.getLocation()) : null;
            if (location == null) {
                return new int[]{-1, -1};
            }
        }
        return new int[]{location.getBlock().getLightFromSky(), location.getBlock().getLightFromBlocks()};
    }

    @Override
    public float getYaw() {
        return this.player.getLocation().getYaw();
    }

    @Override
    public float getPitch() {
        return this.player.getLocation().getPitch();
    }

    @Override
    public Vec getVec() {
        return new Vec(this.player.getLocation().getX(), this.player.getLocation().getY() + 1.0, this.player.getLocation().getZ());
    }

    @Override
    public Loc getLoc() {
        if (this.isValid()) {
            return new Loc(new Player(this.player));
        }
        return new Loc();
    }

    public org.bukkit.entity.Player getPlayer() {
        return this.player;
    }

    @Override
    public void spawnParticle(ParticleType particleType, Vec position) {
        this.player.spawnParticle(Particle.DUST, position.getX(), position.getY(), position.getZ(), 1, (Object)this.getParticle(particleType));
    }

    public Particle.DustOptions getParticle(ParticleType particleType) {
        String color2;
        float size = switch (particleType) {
            case ParticleType.DEST -> {
                color2 = this.getPData().getDEST().getSetting().getParticles().getDestColor();
                yield 3.0f;
            }
            case ParticleType.LINE -> {
                color2 = this.getPData().getDEST().getSetting().getParticles().getLineColor();
                yield 1.0f;
            }
            case ParticleType.TRACKING -> {
                color2 = this.getPData().getDEST().getSetting().getParticles().getTrackingColor();
                yield 0.5f;
            }
            default -> {
                color2 = "#000000";
                yield 1.0f;
            }
        };
        int[] rgb = CUtl.color.RGB(color2);
        return new Particle.DustOptions(Color.fromRGB((int)rgb[0], (int)rgb[1], (int)rgb[2]), size);
    }
}

