/*
 * Decompiled with CFR 0.152.
 */
package one.oth3r.directionhud.utils;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.kyori.adventure.text.TextComponent;
import one.oth3r.directionhud.common.files.LangReader;
import one.oth3r.directionhud.common.files.dimension.Dimension;
import one.oth3r.directionhud.common.files.dimension.DimensionEntry;
import one.oth3r.directionhud.common.files.dimension.RatioEntry;
import one.oth3r.directionhud.common.template.FeatureChecker;
import one.oth3r.directionhud.common.utils.Helper;
import one.oth3r.directionhud.utils.CTxT;
import one.oth3r.directionhud.utils.Player;
import org.bukkit.Bukkit;
import org.bukkit.World;

public class Utl {
    public static CTxT getTranslation(String key, Object ... args) {
        return LangReader.of("key.directionhud." + key, args).getTxT();
    }

    public static CTxT getTxTFromObj(Object obj) {
        CTxT txt = CTxT.of("");
        if (obj instanceof CTxT) {
            txt.append(((CTxT)obj).b());
        } else if (obj instanceof TextComponent) {
            txt.append((TextComponent)obj);
        } else {
            txt.append(String.valueOf(obj));
        }
        return txt;
    }

    public static List<Player> getPlayers() {
        ArrayList<Player> array = new ArrayList<Player>();
        for (org.bukkit.entity.Player p : Bukkit.getOnlinePlayers()) {
            array.add(new Player(p));
        }
        return array;
    }

    public static class dim {
        public static final ArrayList<DimensionEntry> DEFAULT_DIMENSIONS = new ArrayList<DimensionEntry>(Arrays.asList(new DimensionEntry(dim.format((World)Bukkit.getWorlds().get(0)), "Overworld", "#55FF55", Dimension.OVERWORLD_TIME_ENTRY), new DimensionEntry(dim.format((World)Bukkit.getWorlds().get(0)) + "_nether", "Nether", "#e8342e", new DimensionEntry.Time()), new DimensionEntry(dim.format((World)Bukkit.getWorlds().get(0)) + "_the_end", "End", "#edffb0", new DimensionEntry.Time())));
        public static final ArrayList<RatioEntry> DEFAULT_RATIOS = new ArrayList<RatioEntry>(List.of(new RatioEntry(new Helper.Pair<String, Double>(dim.format((World)Bukkit.getWorlds().get(0)), 1.0), new Helper.Pair<CallSite, Double>((CallSite)((Object)(dim.format((World)Bukkit.getWorlds().get(0)) + "_nether")), 8.0))));

        public static String format(World world) {
            return world.getName();
        }

        public static String legacyFormatter(String dimension) {
            String defaultWorld = ((World)Bukkit.getWorlds().get(0)).getName();
            if (dimension.equals(defaultWorld)) {
                return "overworld";
            }
            String[] split = dimension.split("_");
            return split[split.length - 1];
        }

        public static String updateLegacy(String oldDimension) {
            for (World world : Bukkit.getWorlds()) {
                if (!dim.legacyFormatter(world.getName()).equals(oldDimension)) continue;
                return dim.format(world);
            }
            return oldDimension;
        }

        public static void addMissing(ArrayList<DimensionEntry> dimensions) {
            Random random = new Random();
            for (World world : Bukkit.getWorlds()) {
                String currentDIM = dim.format(world);
                if (dimensions.stream().anyMatch(dimension -> dimension.getId().equals(currentDIM))) continue;
                DimensionEntry entry = new DimensionEntry();
                entry.setId(currentDIM);
                entry.setName(dim.getFormattedDimName(currentDIM));
                entry.setColor(String.format("#%02x%02x%02x", random.nextInt(100, 256), random.nextInt(100, 256), random.nextInt(100, 256)));
                dimensions.add(entry);
            }
        }

        private static String getFormattedDimName(String worldName) {
            worldName = ((String)worldName).replaceAll("_", " ");
            worldName = ((String)worldName).replaceFirst("the ", "");
            worldName = ((String)worldName).substring(0, 1).toUpperCase() + ((String)worldName).substring(1);
            return worldName;
        }
    }

    public static class CheckEnabled
    extends FeatureChecker {
        public CheckEnabled(Player player) {
            super(player);
        }

        @Override
        public boolean reload() {
            return this.player.getPlayer().hasPermission("directionhud.reload");
        }

        @Override
        public boolean globalEditing() {
            return super.globalEditing() && this.player.getPlayer().hasPermission("directionhud.destination.global-saving");
        }

        @Override
        public boolean hud() {
            return super.hud() && this.player.getPlayer().hasPermission("directionhud.hud");
        }

        @Override
        public boolean destination() {
            return super.destination() && this.player.getPlayer().hasPermission("directionhud.destination");
        }

        @Override
        public boolean saving() {
            return super.saving() && this.player.getPlayer().hasPermission("directionhud.destination.saving");
        }
    }
}

