/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.helpers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.keehl.elevators.helpers.ElevatorHelper;
import me.keehl.elevators.helpers.MessageHelper;
import me.keehl.elevators.helpers.TagHelper;
import me.keehl.elevators.models.Elevator;
import me.keehl.elevators.models.ElevatorType;
import me.keehl.elevators.services.ElevatorDataContainerService;
import me.keehl.elevators.services.ElevatorSettingService;
import me.keehl.elevators.util.InternalElevatorSettingType;
import org.bukkit.DyeColor;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.entity.Item;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemStackHelper {
    private static final Pattern dyeColorPattern = Pattern.compile("(?:LIGHT_)?.+?(?=_)");

    public static boolean isNotShulkerBox(Material type) {
        return !TagHelper.SHULKER_BOXES.isTagged((Keyed)type);
    }

    public static DyeColor getDyeColorFromMaterial(Material material) {
        Matcher matcher = dyeColorPattern.matcher(material.name());
        if (!matcher.find()) {
            return null;
        }
        try {
            return DyeColor.valueOf((String)matcher.group());
        }
        catch (Exception ignored) {
            return null;
        }
    }

    public static Material getVariant(Material type, DyeColor color) {
        String name = type.toString().toLowerCase();
        for (DyeColor tColor : DyeColor.values()) {
            if (!name.startsWith(tColor.toString().toLowerCase() + "_")) continue;
            name = name.replaceFirst(Pattern.quote(tColor.toString().toLowerCase()), "");
        }
        name = (color.toString() + name).toUpperCase();
        Material variant = Material.matchMaterial((String)name);
        return variant == null ? type : variant;
    }

    private static ItemStack findElevatorType(ElevatorType elevatorType, ItemStack item, Inventory inv) {
        ItemStack elevator = null;
        int maxStackSize = (Integer)ElevatorSettingService.getElevatorSettingValue(elevatorType, InternalElevatorSettingType.MAX_STACK_SIZE);
        for (ItemStack content : inv.getContents()) {
            if (content == null || content.getType().equals((Object)Material.AIR) || ElevatorHelper.getElevatorType(content) == null || !content.isSimilar(item) || !Objects.equals(ElevatorHelper.getElevatorType(content), elevatorType) || content.getAmount() >= maxStackSize) continue;
            elevator = content;
            break;
        }
        return elevator;
    }

    public static ItemStack createItemStackFromElevatorType(ElevatorType elevatorType, DyeColor dyeColor) {
        ItemStack itemStack = new ItemStack(ItemStackHelper.getVariant(Material.WHITE_SHULKER_BOX, dyeColor), 1);
        ItemMeta meta = itemStack.getItemMeta();
        if (meta == null) {
            return itemStack;
        }
        meta.setDisplayName(MessageHelper.formatLineColors((String)ElevatorSettingService.getElevatorSettingValue(elevatorType, InternalElevatorSettingType.DISPLAY_NAME)));
        meta.setLore(MessageHelper.formatListColors((List)ElevatorSettingService.getElevatorSettingValue(elevatorType, InternalElevatorSettingType.LORE_LINES)));
        itemStack.setItemMeta(meta);
        ElevatorDataContainerService.setElevatorKey(itemStack, elevatorType);
        return itemStack;
    }

    public static ItemStack createItemStackFromElevator(Elevator elevator) {
        ItemStack itemStack = ItemStackHelper.createItemStackFromElevatorType(elevator.getElevatorType(), DyeColor.WHITE);
        itemStack.setType(elevator.getShulkerBox().getType());
        ElevatorDataContainerService.dumpDataFromShulkerBoxIntoItem(elevator.getShulkerBox(), itemStack);
        return itemStack;
    }

    public static void updateElevator(ElevatorType elevatorType, ItemStack currentStack) {
        ItemStack newStack = ItemStackHelper.createItemStackFromElevatorType(elevatorType, ItemStackHelper.getDyeColorFromMaterial(currentStack.getType()));
        newStack.setAmount(currentStack.getAmount());
        currentStack.setItemMeta(newStack.getItemMeta());
    }

    public static void giveElevator(Item itemEntity, Inventory inv) {
        ItemStack item = itemEntity.getItemStack();
        ElevatorType elevatorType = ElevatorHelper.getElevatorType(item);
        if (elevatorType == null) {
            return;
        }
        ElevatorDataContainerService.updateItemStackFromV2(item, elevatorType);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(MessageHelper.formatLineColors((String)ElevatorSettingService.getElevatorSettingValue(elevatorType, InternalElevatorSettingType.DISPLAY_NAME)));
            meta.setLore(MessageHelper.formatListColors((List)ElevatorSettingService.getElevatorSettingValue(elevatorType, InternalElevatorSettingType.LORE_LINES)));
            item.setItemMeta(meta);
        }
        while (item.getAmount() > 0) {
            ItemStack elevator = ItemStackHelper.findElevatorType(elevatorType, item, inv);
            if (elevator == null) {
                elevator = item.clone();
                elevator.setAmount(1);
                if (!inv.addItem(new ItemStack[]{elevator}).isEmpty()) {
                    break;
                }
            } else {
                elevator.setAmount(elevator.getAmount() + 1);
            }
            item.setAmount(item.getAmount() - 1);
        }
        if (item.getAmount() <= 0) {
            itemEntity.remove();
        } else {
            itemEntity.setItemStack(item);
        }
    }

    public static Map<ItemStack, Integer> addElevatorToInventory(ElevatorType elevatorType, int itemAmount, Material dyeMaterial, Inventory inventory) {
        List lore = (List)ElevatorSettingService.getElevatorSettingValue(elevatorType, InternalElevatorSettingType.LORE_LINES);
        String displayName = (String)ElevatorSettingService.getElevatorSettingValue(elevatorType, InternalElevatorSettingType.DISPLAY_NAME);
        return ItemStackHelper.addElevatorToInventory(elevatorType, itemAmount, dyeMaterial, inventory, displayName, lore);
    }

    public static Map<ItemStack, Integer> addElevatorToInventory(ElevatorType elevatorType, int itemAmount, Material dyeMaterial, Inventory inventory, String displayName, List<String> lore) {
        displayName = MessageHelper.formatLineColors(displayName);
        lore = MessageHelper.formatListColors(lore);
        HashMap<ItemStack, Integer> partialList = new HashMap<ItemStack, Integer>();
        ItemStack newElevator = ItemStackHelper.createItemStackFromElevatorType(elevatorType, ItemStackHelper.getDyeColorFromMaterial(dyeMaterial));
        int maxStackSize = (Integer)ElevatorSettingService.getElevatorSettingValue(elevatorType, InternalElevatorSettingType.MAX_STACK_SIZE);
        for (ItemStack inventoryItem : inventory.getContents()) {
            if (inventoryItem == null || inventoryItem.getType() != dyeMaterial || ItemStackHelper.isNotShulkerBox(inventoryItem.getType()) || !ElevatorHelper.isElevator(inventoryItem) || ElevatorHelper.getElevatorType(inventoryItem) != elevatorType || inventoryItem.getAmount() >= maxStackSize || !inventoryItem.isSimilar(newElevator)) continue;
            int amountToGive = maxStackSize - inventoryItem.getAmount();
            amountToGive = Math.min(amountToGive, itemAmount);
            inventoryItem.setAmount(inventoryItem.getAmount() + amountToGive);
            if ((itemAmount -= amountToGive) == 0) break;
        }
        if (itemAmount > 0) {
            ItemMeta itemMeta = newElevator.getItemMeta();
            itemMeta.setDisplayName(displayName);
            itemMeta.setLore(lore);
            newElevator.setItemMeta(itemMeta);
            int leftoverToGive = itemAmount % maxStackSize;
            int stacksToGive = (itemAmount - leftoverToGive) / maxStackSize;
            for (int i = 0; i < stacksToGive; ++i) {
                ItemStack newItem = newElevator.clone();
                newItem.setAmount(maxStackSize);
                partialList.put(newItem, maxStackSize);
            }
            ItemStack newItem = newElevator.clone();
            newItem.setAmount(leftoverToGive);
            partialList.put(newItem, leftoverToGive);
        }
        ArrayList keySet = new ArrayList(partialList.keySet());
        for (ItemStack itemKey : keySet) {
            int firstEmpty = inventory.firstEmpty();
            if (firstEmpty == -1) break;
            inventory.setItem(firstEmpty, itemKey);
            partialList.remove(itemKey);
        }
        return partialList;
    }

    private static ItemStack createItem(Material type, int amount) {
        if (type == null) {
            return null;
        }
        return new ItemStack(type, amount);
    }

    public static ItemStack createItem(String name, Material type, int amount) {
        ItemStack item = ItemStackHelper.createItem(type, amount);
        if (name == null || item == null || item.getItemMeta() == null) {
            return item;
        }
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(name);
        item.setItemMeta(meta);
        return item;
    }

    public static ItemStack createItem(String name, Material type, int amount, List<String> lore) {
        ItemStack item = ItemStackHelper.createItem(name, type, amount);
        if (item == null || item.getItemMeta() == null) {
            return item;
        }
        ItemMeta meta = item.getItemMeta();
        meta.setLore(lore);
        item.setItemMeta(meta);
        return item;
    }

    public static ItemStack createItem(String name, Material type, int amount, String ... lore) {
        return ItemStackHelper.createItem(name, type, amount, Arrays.asList(lore));
    }
}

