/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.helpers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import me.keehl.elevators.helpers.ItemStackHelper;
import org.bukkit.Bukkit;
import org.bukkit.DyeColor;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Tag;
import org.jetbrains.annotations.NotNull;

public class TagHelper {
    public static Tag<Material> SHULKER_BOXES = Bukkit.getTag((String)"blocks", (NamespacedKey)NamespacedKey.minecraft((String)"shulker_boxes"), Material.class);
    public static Tag<Material> ITEMS_CREEPER_DROP_MUSIC_DISCS;
    public static Tag<Material> ITEMS_BOOKSHELF_BOOKS;

    static {
        if (SHULKER_BOXES == null || SHULKER_BOXES.getValues().isEmpty()) {
            List boxes = Arrays.stream(DyeColor.values()).map(x -> ItemStackHelper.getVariant(Material.RED_SHULKER_BOX, x)).collect(Collectors.toList());
            boxes.add(Material.SHULKER_BOX);
            SHULKER_BOXES = new FakeTag<Material>(NamespacedKey.minecraft((String)"shulker_boxes"), new HashSet(boxes));
        }
        if ((ITEMS_CREEPER_DROP_MUSIC_DISCS = Bukkit.getTag((String)"blocks", (NamespacedKey)NamespacedKey.minecraft((String)"creeper_drop_music_discs"), Material.class)) == null || ITEMS_CREEPER_DROP_MUSIC_DISCS.getValues().isEmpty()) {
            ArrayList<Material> discs = new ArrayList<Material>();
            discs.add(Material.MUSIC_DISC_11);
            discs.add(Material.MUSIC_DISC_13);
            discs.add(Material.MUSIC_DISC_BLOCKS);
            discs.add(Material.MUSIC_DISC_CAT);
            discs.add(Material.MUSIC_DISC_CHIRP);
            discs.add(Material.MUSIC_DISC_FAR);
            discs.add(Material.MUSIC_DISC_MALL);
            discs.add(Material.MUSIC_DISC_MELLOHI);
            discs.add(Material.MUSIC_DISC_STAL);
            discs.add(Material.MUSIC_DISC_STRAD);
            discs.add(Material.MUSIC_DISC_WAIT);
            discs.add(Material.MUSIC_DISC_WARD);
            ITEMS_CREEPER_DROP_MUSIC_DISCS = new FakeTag(NamespacedKey.minecraft((String)"creeper_drop_music_discs"), new HashSet(discs));
        }
        if ((ITEMS_BOOKSHELF_BOOKS = Bukkit.getTag((String)"blocks", (NamespacedKey)NamespacedKey.minecraft((String)"bookshelf_books"), Material.class)) == null || ITEMS_BOOKSHELF_BOOKS.getValues().isEmpty()) {
            ArrayList<Material> books = new ArrayList<Material>();
            books.add(Material.BOOK);
            books.add(Material.ENCHANTED_BOOK);
            books.add(Material.WRITABLE_BOOK);
            books.add(Material.KNOWLEDGE_BOOK);
            ITEMS_BOOKSHELF_BOOKS = new FakeTag(NamespacedKey.minecraft((String)"bookshelf_books"), new HashSet(books));
        }
    }

    private static class FakeTag<T extends Keyed>
    implements Tag<T> {
        private final Set<T> collection;
        private final NamespacedKey key;

        public FakeTag(NamespacedKey key, Set<T> collection) {
            this.collection = collection;
            this.key = key;
        }

        public boolean isTagged(@NotNull T item) {
            return this.collection.contains(item);
        }

        @NotNull
        public Set<T> getValues() {
            return this.collection;
        }

        @NotNull
        public NamespacedKey getKey() {
            return this.key;
        }
    }
}

