/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.services;

import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import me.keehl.elevators.Elevators;
import me.keehl.elevators.helpers.ElevatorHelper;
import me.keehl.elevators.helpers.MessageHelper;
import me.keehl.elevators.models.Elevator;
import me.keehl.elevators.models.ElevatorType;
import me.keehl.elevators.util.persistantDataTypes.BooleanPersistentDataType;
import me.keehl.elevators.util.persistantDataTypes.StringArrayPersistentDataType;
import org.bukkit.ChatColor;
import org.bukkit.NamespacedKey;
import org.bukkit.block.ShulkerBox;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class ElevatorDataContainerService {
    private static final Map<String, Map.Entry<NamespacedKey, PersistentDataType<?, ?>>> keyMap = new HashMap();
    private static boolean initialized = false;
    private static NamespacedKey typeKey;
    private static NamespacedKey nameKey;
    public static StringArrayPersistentDataType stringArrayPersistentDataType;
    public static BooleanPersistentDataType booleanPersistentDataType;

    public static void init() {
        if (initialized) {
            return;
        }
        Elevators.pushAndHoldLog();
        typeKey = ElevatorDataContainerService.getKeyFromKey("elevator-type", PersistentDataType.STRING);
        nameKey = ElevatorDataContainerService.getKeyFromKey("floor-name", PersistentDataType.STRING);
        initialized = true;
        Elevators.popLog(logData -> Elevators.log("Data Container service enabled. " + ChatColor.YELLOW + "Took " + logData.getElapsedTime() + "ms"));
    }

    public static NamespacedKey createKey(String key) {
        return new NamespacedKey((Plugin)Elevators.getInstance(), key);
    }

    public static NamespacedKey getKeyFromKey(String keyKey, PersistentDataType<?, ?> dataType) {
        if (!keyMap.containsKey(keyKey = keyKey.toLowerCase())) {
            keyMap.put(keyKey, new AbstractMap.SimpleEntry(ElevatorDataContainerService.createKey(keyKey), dataType));
        }
        return keyMap.get(keyKey).getKey();
    }

    private static void transferDataBetweenContainers(PersistentDataContainer from, PersistentDataContainer to) {
        for (String keyKey : keyMap.keySet()) {
            Map.Entry<NamespacedKey, PersistentDataType<?, ?>> keyData = keyMap.get(keyKey);
            Object boxValue = from.get(keyData.getKey(), keyData.getValue());
            if (boxValue == null) continue;
            PersistentDataType<?, ?> boxType = keyData.getValue();
            to.set(keyData.getKey(), boxType, boxValue);
        }
    }

    public static void dumpDataFromShulkerBoxIntoItem(ShulkerBox shulkerBox, ItemStack item) {
        if (!item.hasItemMeta()) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        PersistentDataContainer boxDataContainer = shulkerBox.getPersistentDataContainer();
        PersistentDataContainer itemDataContainer = meta.getPersistentDataContainer();
        ElevatorDataContainerService.transferDataBetweenContainers(boxDataContainer, itemDataContainer);
        item.setItemMeta(meta);
    }

    public static void dumpDataFromItemIntoShulkerBox(ShulkerBox shulkerBox, ItemStack item) {
        if (!item.hasItemMeta()) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        PersistentDataContainer boxDataContainer = shulkerBox.getPersistentDataContainer();
        PersistentDataContainer itemDataContainer = meta.getPersistentDataContainer();
        ElevatorDataContainerService.transferDataBetweenContainers(itemDataContainer, boxDataContainer);
    }

    public static void dumpDataFromItemIntoItem(ItemStack originItem, ItemStack destinationItem) {
        if (!originItem.hasItemMeta() || originItem.getType() != destinationItem.getType()) {
            return;
        }
        destinationItem.setItemMeta(originItem.getItemMeta());
    }

    public static String getElevatorKey(ItemStack item) {
        PersistentDataContainer tagContainer;
        ItemMeta meta = item.getItemMeta();
        if (meta != null && (tagContainer = meta.getPersistentDataContainer()).has(typeKey, PersistentDataType.STRING)) {
            return (String)tagContainer.get(typeKey, PersistentDataType.STRING);
        }
        return null;
    }

    public static String getElevatorKey(ShulkerBox box) {
        PersistentDataContainer tagContainer = box.getPersistentDataContainer();
        if (tagContainer.has(typeKey, PersistentDataType.STRING)) {
            return (String)tagContainer.get(typeKey, PersistentDataType.STRING);
        }
        return null;
    }

    public static <T> T getElevatorValue(ShulkerBox box, NamespacedKey key, T defaultValue) {
        Map.Entry<NamespacedKey, PersistentDataType<?, ?>> keyData = keyMap.get(key.getKey());
        PersistentDataContainer dataContainer = box.getPersistentDataContainer();
        if (!dataContainer.has(keyData.getKey(), keyData.getValue())) {
            return defaultValue;
        }
        Object boxValue = dataContainer.get(keyData.getKey(), keyData.getValue());
        return (T)boxValue;
    }

    public static <Z> void setElevatorValue(ShulkerBox box, NamespacedKey key, Z value) {
        Map.Entry<NamespacedKey, PersistentDataType<?, ?>> keyData = keyMap.get(key.getKey());
        PersistentDataContainer dataContainer = box.getPersistentDataContainer();
        if (value == null) {
            dataContainer.remove(keyData.getKey());
            return;
        }
        PersistentDataType<?, ?> dataType = keyData.getValue();
        dataContainer.set(keyData.getKey(), dataType, value);
    }

    public static void setElevatorKey(ItemStack item, ElevatorType type) {
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.getPersistentDataContainer().set(typeKey, PersistentDataType.STRING, (Object)type.getTypeKey());
        }
        item.setItemMeta(meta);
    }

    public static ShulkerBox updateTypeKeyOnElevator(ShulkerBox box, ElevatorType type) {
        box.getPersistentDataContainer().set(typeKey, PersistentDataType.STRING, (Object)type.getTypeKey());
        box.update();
        return box;
    }

    public static ShulkerBox updateBox(ShulkerBox box, ElevatorType type) {
        box.update(true);
        return ElevatorDataContainerService.updateTypeKeyOnElevator(box, type);
    }

    public static void updateItemStackFromV2(ItemStack item, ElevatorType type) {
        String name;
        int sub;
        if (!item.hasItemMeta() || item.getItemMeta() == null) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta.hasDisplayName() && (sub = (name = meta.getDisplayName()).indexOf(MessageHelper.hideText("CoreEleKey:"))) > -1) {
            name = name.substring(0, sub);
            meta.setDisplayName(name);
        }
        meta.getPersistentDataContainer().set(typeKey, PersistentDataType.STRING, (Object)type.getTypeKey());
        item.setItemMeta(meta);
    }

    public static String getFloorName(Elevator elevator) {
        PersistentDataContainer tagContainer = elevator.getShulkerBox().getPersistentDataContainer();
        if (tagContainer.has(nameKey, PersistentDataType.STRING)) {
            return (String)tagContainer.get(nameKey, PersistentDataType.STRING);
        }
        return "Floor #" + ElevatorHelper.getFloorNumberOrCount(elevator, true);
    }

    public static void setFloorName(Elevator elevator, String name) {
        PersistentDataContainer tagContainer = elevator.getShulkerBox().getPersistentDataContainer();
        if (name == null) {
            tagContainer.remove(nameKey);
        } else {
            tagContainer.set(nameKey, PersistentDataType.STRING, (Object)name);
        }
        elevator.getShulkerBox().update(true);
    }

    static {
        stringArrayPersistentDataType = new StringArrayPersistentDataType();
        booleanPersistentDataType = new BooleanPersistentDataType();
    }
}

