/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.services.hooks;

import eu.decentsoftware.holograms.api.DHAPI;
import eu.decentsoftware.holograms.api.holograms.Hologram;
import java.util.Arrays;
import java.util.List;
import me.keehl.elevators.models.Elevator;
import me.keehl.elevators.models.hooks.HologramHook;
import me.keehl.elevators.models.hooks.WrappedHologram;
import org.bukkit.Location;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@NestMembers(value={DecentHologramWrapper.class})
public class DecentHologramsHook
extends HologramHook {
    @Override
    public WrappedHologram createHologram(Elevator elevator, String ... lines) {
        return new DecentHologramWrapper(elevator, new String[0]);
    }

    @Override
    public void onInit() {
    }

    @NestHost(value=DecentHologramsHook.class)
    public static class DecentHologramWrapper
    extends WrappedHologram {
        private final Hologram hologram;

        public DecentHologramWrapper(Elevator elevator, String ... lines) {
            super(elevator);
            this.hologram = DHAPI.createHologram((String)this.getUUID(), (Location)elevator.getLocation().clone());
            this.hologram.setDownOrigin(true);
            Arrays.stream(lines).forEach(i -> DHAPI.addHologramLine((Hologram)this.hologram, (String)i));
            this.hologram.realignLines();
        }

        @Override
        public void addLine(String text) {
            DHAPI.addHologramLine((Hologram)this.hologram, (String)text);
        }

        @Override
        public void setLines(List<String> text) {
            DHAPI.setHologramLines((Hologram)this.hologram, text);
        }

        @Override
        public double getHeight() {
            return this.hologram.getPage(0).getHeight();
        }

        @Override
        public void teleportTo(Location location) {
            DHAPI.moveHologram((Hologram)this.hologram, (Location)location);
        }

        @Override
        public void onDelete() {
            this.hologram.delete();
        }
    }
}

