/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.util.signgui;

import java.util.List;
import me.keehl.elevators.util.signgui.SignEditor;
import me.keehl.elevators.util.signgui.SignGUIAction;
import me.keehl.elevators.util.signgui.SignGUIBuilder;
import me.keehl.elevators.util.signgui.SignGUIFinishHandler;
import me.keehl.elevators.util.signgui.SignGUIResult;
import me.keehl.elevators.util.signgui.exception.SignGUIException;
import me.keehl.elevators.util.signgui.exception.SignGUIVersionException;
import me.keehl.elevators.util.signgui.version.VersionMatcher;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class SignGUI {
    private final String[] lines;
    private final Object[] adventureLines;
    private final Material type;
    private final DyeColor color;
    private final boolean glow;
    private final Location signLoc;
    private final SignGUIFinishHandler handler;
    private final boolean callHandlerSynchronously;
    private final JavaPlugin plugin;

    public static SignGUIBuilder builder() throws SignGUIVersionException {
        return new SignGUIBuilder(VersionMatcher.getWrapper());
    }

    SignGUI(String[] lines, Object[] adventureLines, Material type, DyeColor color, boolean glow, Location signLoc, SignGUIFinishHandler handler, boolean callHandlerSynchronously, JavaPlugin plugin) {
        this.lines = lines;
        this.adventureLines = adventureLines;
        this.type = type;
        this.color = color;
        this.glow = glow;
        this.signLoc = signLoc;
        this.handler = handler;
        this.callHandlerSynchronously = callHandlerSynchronously;
        this.plugin = plugin;
    }

    public void open(Player player) throws SignGUIException {
        Validate.notNull((Object)player, (String)"The player cannot be null");
        try {
            VersionMatcher.getWrapper().openSignEditor(player, this.lines, this.adventureLines, this.type, this.color, this.glow, this.signLoc, (signEditor, resultLines) -> {
                Runnable runnable = () -> {
                    Runnable close = () -> {
                        try {
                            VersionMatcher.getWrapper().closeSignEditor(player, (SignEditor)signEditor);
                        }
                        catch (SignGUIVersionException e) {
                            throw new SignGUIException("Failed to close sign editor", e);
                        }
                    };
                    List<SignGUIAction> actions = this.handler.onFinish(player, new SignGUIResult((String[])resultLines));
                    if (actions == null || actions.isEmpty()) {
                        close.run();
                        return;
                    }
                    boolean keepOpen = false;
                    for (SignGUIAction action : actions) {
                        SignGUIAction.SignGUIActionInfo info = action.getInfo();
                        for (SignGUIAction otherAction : actions) {
                            SignGUIAction.SignGUIActionInfo otherInfo;
                            if (action == otherAction || !info.isConflicting(otherInfo = otherAction.getInfo())) continue;
                            close.run();
                            throw new IllegalArgumentException("The actions " + info.getName() + " and " + otherInfo.getName() + " are conflicting");
                        }
                        if (!info.isKeepOpen()) continue;
                        keepOpen = true;
                    }
                    if (!keepOpen) {
                        close.run();
                    }
                    for (SignGUIAction action : actions) {
                        action.execute(this, (SignEditor)signEditor, player);
                    }
                };
                if (this.callHandlerSynchronously) {
                    Bukkit.getScheduler().runTask((Plugin)this.plugin, runnable);
                } else {
                    runnable.run();
                }
            });
        }
        catch (Exception e) {
            throw new SignGUIException("Failed to open sign gui", e);
        }
    }

    void displayNewLines(Player player, SignEditor signEditor, String[] lines, Object[] adventureLines) {
        Validate.notNull((Object)lines, (String)"The lines cannot be null");
        Validate.isTrue((lines.length == 4 ? 1 : 0) != 0, (String)"The lines must have a length of 4");
        if (adventureLines != null) {
            Validate.isTrue((adventureLines.length == 4 ? 1 : 0) != 0, (String)"The adventure lines must null or have a length of 4");
        }
        try {
            VersionMatcher.getWrapper().displayNewLines(player, signEditor, lines, adventureLines);
        }
        catch (Exception e) {
            throw new SignGUIException("Failed to display new lines", e);
        }
    }
}

