/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.util.signgui;

import java.util.Arrays;
import me.keehl.elevators.util.signgui.SignEditor;
import me.keehl.elevators.util.signgui.SignGUI;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public interface SignGUIAction {
    public SignGUIActionInfo getInfo();

    public void execute(SignGUI var1, SignEditor var2, Player var3);

    public static SignGUIAction displayNewLines(final String ... lines) {
        Validate.notNull((Object)lines, (String)"The lines cannot be null");
        return new SignGUIAction(){
            private SignGUIActionInfo info = new SignGUIActionInfo("displayNewLines", true, 1);

            @Override
            public SignGUIActionInfo getInfo() {
                return this.info;
            }

            @Override
            public void execute(SignGUI gui, SignEditor signEditor, Player player) {
                gui.displayNewLines(player, signEditor, Arrays.copyOf(lines, 4), null);
            }
        };
    }

    public static SignGUIAction displayNewAdventureLines(Object ... adventureLines) {
        return SignGUIAction.displayNewAdventureLines(adventureLines, null);
    }

    public static SignGUIAction displayNewAdventureLines(final Object[] adventureLines, final String[] fallbackLines) {
        Validate.notNull((Object)adventureLines, (String)"The lines cannot be null");
        return new SignGUIAction(){
            private SignGUIActionInfo info = new SignGUIActionInfo("displayNewLines", true, 1);

            @Override
            public SignGUIActionInfo getInfo() {
                return this.info;
            }

            @Override
            public void execute(SignGUI gui, SignEditor signEditor, Player player) {
                gui.displayNewLines(player, signEditor, fallbackLines != null ? Arrays.copyOf(fallbackLines, 4) : new String[4], Arrays.copyOf(adventureLines, 4));
            }
        };
    }

    public static SignGUIAction openInventory(final JavaPlugin plugin, final Inventory inventory) {
        Validate.notNull((Object)plugin, (String)"The plugin cannot be null");
        Validate.notNull((Object)inventory, (String)"The inventory cannot be null");
        return new SignGUIAction(){
            private SignGUIActionInfo info = new SignGUIActionInfo("openInventory", false, 1);

            @Override
            public SignGUIActionInfo getInfo() {
                return this.info;
            }

            @Override
            public void execute(SignGUI gui, SignEditor signEditor, Player player) {
                Bukkit.getScheduler().runTask((Plugin)plugin, () -> player.openInventory(inventory));
            }
        };
    }

    public static SignGUIAction run(final Runnable runnable) {
        Validate.notNull((Object)runnable, (String)"The runnable cannot be null");
        return new SignGUIAction(){
            private SignGUIActionInfo info = new SignGUIActionInfo("run", false, 0);

            @Override
            public SignGUIActionInfo getInfo() {
                return this.info;
            }

            @Override
            public void execute(SignGUI gui, SignEditor signEditor, Player player) {
                runnable.run();
            }
        };
    }

    public static SignGUIAction runSync(final JavaPlugin plugin, final Runnable runnable) {
        Validate.notNull((Object)plugin, (String)"The plugin cannot be null");
        Validate.notNull((Object)runnable, (String)"The runnable cannot be null");
        return new SignGUIAction(){
            private SignGUIActionInfo info = new SignGUIActionInfo("runSync", false, 0);

            @Override
            public SignGUIActionInfo getInfo() {
                return this.info;
            }

            @Override
            public void execute(SignGUI gui, SignEditor signEditor, Player player) {
                Bukkit.getScheduler().runTask((Plugin)plugin, runnable);
            }
        };
    }

    public static class SignGUIActionInfo {
        private final String name;
        private final boolean keepOpen;
        private final int conflicting;

        public SignGUIActionInfo(String name, boolean keepOpen, int conflicting) {
            this.name = name;
            this.keepOpen = keepOpen;
            this.conflicting = conflicting;
        }

        public String getName() {
            return this.name;
        }

        public boolean isKeepOpen() {
            return this.keepOpen;
        }

        public boolean isConflicting(SignGUIActionInfo other) {
            return (this.conflicting & other.conflicting) != 0;
        }
    }
}

