/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.util.signgui.version;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.papermc.paper.adventure.AdventureComponent;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import me.keehl.elevators.util.signgui.SignEditor;
import me.keehl.elevators.util.signgui.SignGUIChannelHandler;
import me.keehl.elevators.util.signgui.version.VersionWrapper;
import net.minecraft.core.BlockPos;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundOpenSignEditorPacket;
import net.minecraft.network.protocol.game.ServerboundSignUpdatePacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.SignText;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.entity.Player;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@NestMembers(value={1.class})
public class MojangWrapper1_20_R4
implements VersionWrapper {
    @Override
    public Material getDefaultType() {
        return Material.OAK_SIGN;
    }

    @Override
    public List<Material> getSignTypes() {
        return Arrays.asList(Material.OAK_SIGN, Material.BIRCH_SIGN, Material.SPRUCE_SIGN, Material.JUNGLE_SIGN, Material.ACACIA_SIGN, Material.DARK_OAK_SIGN, Material.CRIMSON_SIGN, Material.WARPED_SIGN, Material.CHERRY_SIGN, Material.MANGROVE_SIGN, Material.BAMBOO_SIGN);
    }

    private static Component[] createLines(String[] textLines, Object[] adventureLines) {
        Component[] lines = new Component[4];
        if (adventureLines != null) {
            for (int i = 0; i < adventureLines.length; ++i) {
                Object line = adventureLines[i];
                if (line instanceof net.kyori.adventure.text.Component) {
                    net.kyori.adventure.text.Component component = (net.kyori.adventure.text.Component)line;
                    lines[i] = new AdventureComponent(component);
                    continue;
                }
                if (line == null) {
                    lines[i] = Component.empty();
                    continue;
                }
                throw new IllegalArgumentException(MojangWrapper1_20_R4.jvmdowngrader$concat$createLines$1(i));
            }
        } else {
            for (int i = 0; i < textLines.length; ++i) {
                lines[i] = Component.nullToEmpty((String)textLines[i]);
            }
        }
        return lines;
    }

    @Override
    public void openSignEditor(final Player player, String[] textLines, Object[] adventureLines, Material type, DyeColor color, boolean glow, Location signLoc, final BiConsumer<SignEditor, String[]> onFinish) {
        ServerPlayer p = ((CraftPlayer)player).getHandle();
        ServerGamePacketListenerImpl conn = p.connection;
        Location loc = signLoc != null ? signLoc : this.getDefaultLocation(player);
        final BlockPos pos = new BlockPos(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
        SignBlockEntity sign = new SignBlockEntity(pos, null);
        SignText signText = sign.getText(true).setColor(net.minecraft.world.item.DyeColor.valueOf((String)color.toString())).setHasGlowingText(glow);
        Component[] lines = MojangWrapper1_20_R4.createLines(textLines, adventureLines);
        for (int i = 0; i < lines.length; ++i) {
            signText = signText.setMessage(i, lines[i]);
        }
        sign.setText(signText, true);
        boolean schedule = false;
        Connection manager = conn.connection;
        ChannelPipeline pipeline = manager.channel.pipeline();
        if (pipeline.names().contains("SignGUI")) {
            ChannelHandler handler = pipeline.get("SignGUI");
            if (handler instanceof SignGUIChannelHandler) {
                SignGUIChannelHandler signGUIHandler = (SignGUIChannelHandler)handler;
                signGUIHandler.close();
                schedule = signGUIHandler.getBlockPosition().equals(pos);
            }
            if (pipeline.names().contains("SignGUI")) {
                pipeline.remove("SignGUI");
            }
        }
        Runnable runnable = () -> {
            player.sendBlockChange(loc, type.createBlockData());
            sign.setLevel(p.level());
            conn.send((Packet)sign.getUpdatePacket());
            sign.setLevel(null);
            conn.send((Packet)new ClientboundOpenSignEditorPacket(pos, true));
            final SignEditor signEditor = new SignEditor(sign, loc, pos, pipeline);
            pipeline.addAfter("decoder", "SignGUI", (ChannelHandler)new SignGUIChannelHandler<Packet<?>>(){

                @Override
                public Object getBlockPosition() {
                    return pos;
                }

                @Override
                public void close() {
                    MojangWrapper1_20_R4.this.closeSignEditor(player, signEditor);
                }

                protected void decode(ChannelHandlerContext chc, Packet<?> packet, List<Object> out) {
                    try {
                        ServerboundSignUpdatePacket updateSign;
                        if (packet instanceof ServerboundSignUpdatePacket && (updateSign = (ServerboundSignUpdatePacket)packet).getPos().equals((Object)pos)) {
                            onFinish.accept(signEditor, updateSign.getLines());
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    out.add(packet);
                }
            });
        };
        if (schedule) {
            SCHEDULER.schedule(runnable, 200L, TimeUnit.MILLISECONDS);
        } else {
            runnable.run();
        }
    }

    @Override
    public void displayNewLines(Player player, SignEditor signEditor, String[] textLines, Object[] adventureLines) {
        SignBlockEntity sign = (SignBlockEntity)signEditor.getSign();
        SignText newSignText = sign.getText(true);
        Component[] lines = MojangWrapper1_20_R4.createLines(textLines, adventureLines);
        for (int i = 0; i < textLines.length; ++i) {
            newSignText = newSignText.setMessage(i, lines[i]);
        }
        sign.setText(newSignText, true);
        ServerPlayer p = ((CraftPlayer)player).getHandle();
        ServerGamePacketListenerImpl conn = p.connection;
        sign.setLevel(p.level());
        conn.send((Packet)sign.getUpdatePacket());
        sign.setLevel(null);
        conn.send((Packet)new ClientboundOpenSignEditorPacket((BlockPos)signEditor.getBlockPosition(), true));
    }

    @Override
    public void closeSignEditor(Player player, SignEditor signEditor) {
        Location loc = signEditor.getLocation();
        signEditor.getPipeline().remove("SignGUI");
        player.sendBlockChange(loc, loc.getBlock().getBlockData());
    }

    private static /* synthetic */ String jvmdowngrader$concat$createLines$1(int n) {
        return "line at index " + n + " is not net.kyori.adventure.text.Component";
    }
}

