/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.util.signgui.version;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import me.keehl.elevators.util.signgui.SignEditor;
import me.keehl.elevators.util.signgui.SignGUIChannelHandler;
import me.keehl.elevators.util.signgui.version.VersionWrapper;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayInUpdateSign;
import net.minecraft.network.protocol.game.PacketPlayOutOpenSignEditor;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.entity.TileEntitySign;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftPlayer;
import org.bukkit.entity.Player;
import xyz.wagyourtail.jvmdg.j11.NestMembers;
import xyz.wagyourtail.jvmdg.j9.stub.java_base.J_L_R_AccessibleObject;

@NestMembers(value={1.class})
public class Wrapper1_20_R1
implements VersionWrapper {
    private final Field NETWORK_MANAGER_FIELD;

    public Wrapper1_20_R1() {
        Field networkManagerField = null;
        for (Field field : PlayerConnection.class.getDeclaredFields()) {
            if (field.getType() != NetworkManager.class) continue;
            field.setAccessible(true);
            networkManagerField = field;
            break;
        }
        this.NETWORK_MANAGER_FIELD = networkManagerField;
    }

    @Override
    public Material getDefaultType() {
        return Material.OAK_SIGN;
    }

    @Override
    public List<Material> getSignTypes() {
        return Arrays.asList(Material.OAK_SIGN, Material.BIRCH_SIGN, Material.SPRUCE_SIGN, Material.JUNGLE_SIGN, Material.ACACIA_SIGN, Material.DARK_OAK_SIGN, Material.CRIMSON_SIGN, Material.WARPED_SIGN, Material.CHERRY_SIGN, Material.MANGROVE_SIGN, Material.BAMBOO_SIGN);
    }

    @Override
    public void openSignEditor(final Player player, String[] lines, Object[] adventureLines, Material type, DyeColor color, boolean glow, Location signLoc, final BiConsumer<SignEditor, String[]> onFinish) throws IllegalAccessException {
        EntityPlayer p = ((CraftPlayer)player).getHandle();
        PlayerConnection conn = p.c;
        if (this.NETWORK_MANAGER_FIELD == null) {
            throw new IllegalStateException("Unable to find NetworkManager field in PlayerConnection class.");
        }
        if (!J_L_R_AccessibleObject.canAccess((AccessibleObject)this.NETWORK_MANAGER_FIELD, (Object)conn)) {
            this.NETWORK_MANAGER_FIELD.setAccessible(true);
            if (!J_L_R_AccessibleObject.canAccess((AccessibleObject)this.NETWORK_MANAGER_FIELD, (Object)conn)) {
                throw new IllegalStateException("Unable to access NetworkManager field in PlayerConnection class.");
            }
        }
        Location loc = signLoc != null ? signLoc : this.getDefaultLocation(player);
        final BlockPosition pos = new BlockPosition(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
        TileEntitySign sign = new TileEntitySign(pos, null);
        SignText signText = sign.a(true).a(EnumColor.valueOf((String)color.toString())).a(glow);
        for (int i = 0; i < lines.length; ++i) {
            signText = signText.a(i, IChatBaseComponent.a((String)lines[i]));
        }
        sign.a(signText, true);
        boolean schedule = false;
        NetworkManager manager = (NetworkManager)this.NETWORK_MANAGER_FIELD.get(conn);
        ChannelPipeline pipeline = manager.m.pipeline();
        if (pipeline.names().contains("SignGUI")) {
            ChannelHandler handler = pipeline.get("SignGUI");
            if (handler instanceof SignGUIChannelHandler) {
                SignGUIChannelHandler signGUIHandler = (SignGUIChannelHandler)handler;
                signGUIHandler.close();
                schedule = signGUIHandler.getBlockPosition().equals(pos);
            }
            if (pipeline.names().contains("SignGUI")) {
                pipeline.remove("SignGUI");
            }
        }
        Runnable runnable = () -> {
            player.sendBlockChange(loc, type.createBlockData());
            conn.a((Packet)sign.j());
            conn.a((Packet)new PacketPlayOutOpenSignEditor(pos, true));
            final SignEditor signEditor = new SignEditor(sign, loc, pos, pipeline);
            pipeline.addAfter("decoder", "SignGUI", (ChannelHandler)new SignGUIChannelHandler<Packet<?>>(){

                @Override
                public Object getBlockPosition() {
                    return pos;
                }

                @Override
                public void close() {
                    Wrapper1_20_R1.this.closeSignEditor(player, signEditor);
                }

                protected void decode(ChannelHandlerContext chc, Packet<?> packet, List<Object> out) {
                    try {
                        PacketPlayInUpdateSign updateSign;
                        if (packet instanceof PacketPlayInUpdateSign && (updateSign = (PacketPlayInUpdateSign)packet).a().equals((Object)pos)) {
                            onFinish.accept(signEditor, updateSign.d());
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    out.add(packet);
                }
            });
        };
        if (schedule) {
            SCHEDULER.schedule(runnable, 200L, TimeUnit.MILLISECONDS);
        } else {
            runnable.run();
        }
    }

    @Override
    public void displayNewLines(Player player, SignEditor signEditor, String[] lines, Object[] adventureLines) {
        TileEntitySign sign = (TileEntitySign)signEditor.getSign();
        SignText newSignText = sign.a(true);
        for (int i = 0; i < lines.length; ++i) {
            newSignText = newSignText.a(i, IChatBaseComponent.a((String)lines[i]));
        }
        sign.a(newSignText, true);
        PlayerConnection conn = ((CraftPlayer)player).getHandle().c;
        conn.a((Packet)sign.j());
        conn.a((Packet)new PacketPlayOutOpenSignEditor((BlockPosition)signEditor.getBlockPosition(), true));
    }

    @Override
    public void closeSignEditor(Player player, SignEditor signEditor) {
        Location loc = signEditor.getLocation();
        signEditor.getPipeline().remove("SignGUI");
        player.sendBlockChange(loc, loc.getBlock().getBlockData());
    }
}

