/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.commands;

import org.jetbrains.annotations.NotNull;
import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.core.command.MVCommandIssuer;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandCompletion;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandPermission;
import org.mvplugins.multiverse.external.acf.commands.annotation.Description;
import org.mvplugins.multiverse.external.acf.commands.annotation.Subcommand;
import org.mvplugins.multiverse.external.acf.commands.annotation.Syntax;
import org.mvplugins.multiverse.external.acf.locales.MessageKeyProvider;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.inventories.commands.InventoriesCommand;
import org.mvplugins.multiverse.inventories.profile.group.WorldGroup;
import org.mvplugins.multiverse.inventories.profile.group.WorldGroupManager;
import org.mvplugins.multiverse.inventories.share.Shares;
import org.mvplugins.multiverse.inventories.util.MVInvi18n;

@Service
final class AddDisabledSharesCommand
extends InventoriesCommand {
    private final WorldGroupManager worldGroupManager;

    @Inject
    AddDisabledSharesCommand(@NotNull WorldGroupManager worldGroupManager) {
        this.worldGroupManager = worldGroupManager;
    }

    @Subcommand(value="add-disabled-shares")
    @CommandPermission(value="multiverse.inventories.adddisabledshares")
    @CommandCompletion(value="@worldGroups @shares")
    @Syntax(value="<group> <share[,extra]>")
    @Description(value="Add one or more disabled shares to a group.")
    void onAddDisabledSharesCommand(MVCommandIssuer issuer, @Syntax(value="<group>") @Description(value="Group you want to add the disabled shares to.") WorldGroup group, @Syntax(value="<share[,extra]>") @Description(value="One or more sharables to disable for the given group.") Shares shares) {
        group.getDisabledShares().mergeShares(shares);
        this.worldGroupManager.updateGroup(group);
        issuer.sendInfo((MessageKeyProvider)MVInvi18n.DISABLEDSHARES_NOWSHARING, new MessageReplacement[]{MessageReplacement.replace((String)"{group}").with((Object)group.getName()), MessageReplacement.replace((String)"{shares}").with(group.getDisabledShares().toStringList())});
    }
}

