/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.commands;

import java.util.List;
import java.util.Set;
import org.bukkit.Bukkit;
import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.core.command.LegacyAliasCommand;
import org.mvplugins.multiverse.core.command.MVCommandIssuer;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandAlias;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandCompletion;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandPermission;
import org.mvplugins.multiverse.external.acf.commands.annotation.Description;
import org.mvplugins.multiverse.external.acf.commands.annotation.Optional;
import org.mvplugins.multiverse.external.acf.commands.annotation.Single;
import org.mvplugins.multiverse.external.acf.commands.annotation.Subcommand;
import org.mvplugins.multiverse.external.acf.commands.annotation.Syntax;
import org.mvplugins.multiverse.external.acf.locales.MessageKeyProvider;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.inventories.commands.InventoriesCommand;
import org.mvplugins.multiverse.inventories.profile.container.ProfileContainer;
import org.mvplugins.multiverse.inventories.profile.container.ProfileContainerStoreProvider;
import org.mvplugins.multiverse.inventories.profile.group.WorldGroup;
import org.mvplugins.multiverse.inventories.profile.group.WorldGroupManager;
import org.mvplugins.multiverse.inventories.profile.key.ContainerType;
import org.mvplugins.multiverse.inventories.util.MVInvi18n;

@Service
class InfoCommand
extends InventoriesCommand {
    private final ProfileContainerStoreProvider profileContainerStoreProvider;
    private final WorldGroupManager worldGroupManager;

    @Inject
    InfoCommand(@NotNull ProfileContainerStoreProvider profileContainerStoreProvider, @NotNull WorldGroupManager worldGroupManager) {
        this.profileContainerStoreProvider = profileContainerStoreProvider;
        this.worldGroupManager = worldGroupManager;
    }

    @Subcommand(value="info")
    @CommandPermission(value="multiverse.inventories.info")
    @CommandCompletion(value="@mvworlds")
    @Syntax(value="<world|group>")
    @Description(value="World and Group Information")
    void onInfoCommand(@NotNull MVCommandIssuer issuer, @Optional @Single @Syntax(value="<world|group>") @Description(value="World or Group") @NotNull String name) {
        if (name == null) {
            if (!issuer.isPlayer()) {
                issuer.sendError((MessageKeyProvider)MVInvi18n.INFO_ZEROARG);
                return;
            }
            name = issuer.getPlayer().getWorld().getName();
        }
        ProfileContainer worldProfileContainer = this.profileContainerStoreProvider.getStore(ContainerType.WORLD).getContainer(name);
        issuer.sendInfo((MessageKeyProvider)MVInvi18n.INFO_WORLD, new MessageReplacement[]{MessageReplacement.replace((String)"{world}").with((Object)name)});
        if (worldProfileContainer != null && Bukkit.getWorld((String)worldProfileContainer.getContainerName()) != null) {
            this.worldInfo(issuer, worldProfileContainer);
        } else {
            issuer.sendError((MessageKeyProvider)MVInvi18n.ERROR_NOWORLDPROFILE, new MessageReplacement[]{MessageReplacement.replace((String)"{world}").with((Object)name)});
        }
        WorldGroup worldGroup = this.worldGroupManager.getGroup(name);
        issuer.sendInfo((MessageKeyProvider)MVInvi18n.INFO_GROUP, new MessageReplacement[]{MessageReplacement.replace((String)"{group}").with((Object)name)});
        if (worldGroup != null) {
            this.groupInfo(issuer, worldGroup);
        } else {
            issuer.sendError((MessageKeyProvider)MVInvi18n.ERROR_NOGROUP, new MessageReplacement[]{MessageReplacement.replace((String)"{group}").with((Object)name)});
        }
    }

    private void groupInfo(MVCommandIssuer issuer, WorldGroup worldGroup) {
        StringBuilder worldsString = new StringBuilder();
        Set<String> worlds = worldGroup.getWorlds();
        if (worlds.isEmpty()) {
            worldsString.append("N/A");
        } else {
            for (String world : worlds) {
                if (!worldsString.toString().isEmpty()) {
                    worldsString.append(", ");
                }
                worldsString.append(world);
            }
        }
        issuer.sendInfo((MessageKeyProvider)MVInvi18n.INFO_GROUP_INFO, new MessageReplacement[]{MessageReplacement.replace((String)"{worlds}").with((Object)worldsString)});
        issuer.sendInfo((MessageKeyProvider)MVInvi18n.INFO_GROUP_INFOSHARES, new MessageReplacement[]{MessageReplacement.replace((String)"{shares}").with((Object)worldGroup.getShares())});
    }

    private void worldInfo(MVCommandIssuer issuer, ProfileContainer worldProfileContainer) {
        StringBuilder groupsString = new StringBuilder();
        List<WorldGroup> worldGroups = this.worldGroupManager.getGroupsForWorld(worldProfileContainer.getContainerName());
        if (worldGroups.isEmpty()) {
            groupsString.append("N/A");
        } else {
            for (WorldGroup worldGroup : worldGroups) {
                if (!groupsString.toString().isEmpty()) {
                    groupsString.append(", ");
                }
                groupsString.append(worldGroup.getName());
            }
        }
        issuer.sendInfo((MessageKeyProvider)MVInvi18n.INFO_WORLD_INFO, new MessageReplacement[]{MessageReplacement.replace((String)"{groups}").with((Object)groupsString)});
    }

    @Service
    private static final class LegacyAlias
    extends InfoCommand
    implements LegacyAliasCommand {
        @Inject
        LegacyAlias(ProfileContainerStoreProvider profileContainerStoreProvider, WorldGroupManager worldGroupManager) {
            super(profileContainerStoreProvider, worldGroupManager);
        }

        @Override
        @CommandAlias(value="mvinvinfo|mvinvi")
        void onInfoCommand(MVCommandIssuer issuer, String name) {
            super.onInfoCommand(issuer, name);
        }
    }
}

