/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.commands.bulkedit.playerprofile;

import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.core.command.MVCommandIssuer;
import org.mvplugins.multiverse.core.command.queue.CommandQueueManager;
import org.mvplugins.multiverse.core.command.queue.CommandQueuePayload;
import org.mvplugins.multiverse.core.locale.message.Message;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandPermission;
import org.mvplugins.multiverse.external.acf.commands.annotation.Subcommand;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.inventories.commands.InventoriesCommand;
import org.mvplugins.multiverse.inventories.config.InventoriesConfig;
import org.mvplugins.multiverse.inventories.profile.GlobalProfile;
import org.mvplugins.multiverse.inventories.profile.ProfileDataSource;
import org.mvplugins.multiverse.inventories.profile.data.PlayerProfile;
import org.mvplugins.multiverse.inventories.profile.key.ContainerType;
import org.mvplugins.multiverse.inventories.profile.key.GlobalProfileKey;
import org.mvplugins.multiverse.inventories.profile.key.ProfileKey;
import org.mvplugins.multiverse.inventories.profile.key.ProfileTypes;

@Service
final class MigrateInventorySerializationCommand
extends InventoriesCommand {
    private final CommandQueueManager commandQueueManager;
    private final ProfileDataSource profileDataSource;
    private final InventoriesConfig inventoriesConfig;

    @Inject
    MigrateInventorySerializationCommand(@NotNull CommandQueueManager commandQueueManager, @NotNull ProfileDataSource profileDataSource, @NotNull InventoriesConfig inventoriesConfig) {
        this.commandQueueManager = commandQueueManager;
        this.profileDataSource = profileDataSource;
        this.inventoriesConfig = inventoriesConfig;
    }

    @Subcommand(value="bulkedit migrate inventory-serialization nbt")
    @CommandPermission(value="multiverse.inventories.bulkedit")
    void onNbtCommand(MVCommandIssuer issuer) {
        this.commandQueueManager.addToQueue(CommandQueuePayload.issuer((MVCommandIssuer)issuer).prompt(Message.of((String)"Are you sure you want to migrate all player data to NBT?", (MessageReplacement[])new MessageReplacement[0])).action(() -> this.doMigration(issuer, true)));
    }

    @Subcommand(value="bulkedit migrate inventory-serialization bukkit")
    @CommandPermission(value="multiverse.inventories.bulkedit")
    void onBukkitCommand(MVCommandIssuer issuer) {
        this.commandQueueManager.addToQueue(CommandQueuePayload.issuer((MVCommandIssuer)issuer).prompt(Message.of((String)"Are you sure you want to migrate all player data to old Bukkit serialization?", (MessageReplacement[])new MessageReplacement[0])).action(() -> this.doMigration(issuer, false)));
    }

    private void doMigration(MVCommandIssuer issuer, boolean useByteSerialization) {
        this.inventoriesConfig.setUseByteSerializationForInventoryData(useByteSerialization);
        this.inventoriesConfig.save();
        long startTime = System.nanoTime();
        AtomicLong profileCounter = new AtomicLong(0L);
        CompletableFuture.allOf((CompletableFuture[])this.profileDataSource.listGlobalProfileUUIDs().stream().map(playerUUID -> ((CompletableFuture)this.profileDataSource.getGlobalProfile(GlobalProfileKey.of(playerUUID, "")).thenCompose(profile -> this.run((GlobalProfile)profile, profileCounter))).exceptionally(throwable -> {
            issuer.sendMessage("Error updating player " + String.valueOf(playerUUID) + ": " + throwable.getMessage());
            return null;
        })).toArray(CompletableFuture[]::new)).thenRun(() -> {
            long timeDuration = (System.nanoTime() - startTime) / 1000000L;
            issuer.sendMessage("Updated " + profileCounter.get() + " player profiles.");
            issuer.sendMessage("Bulk edit completed in " + timeDuration + " ms.");
        });
    }

    private CompletableFuture<Void> run(GlobalProfile profile, AtomicLong profileCounter) {
        return CompletableFuture.allOf((CompletableFuture[])Arrays.stream(ContainerType.values()).flatMap(containerType -> this.profileDataSource.listContainerDataNames((ContainerType)((Object)containerType)).stream().flatMap(dataName -> ProfileTypes.getTypes().stream().map(profileType -> this.profileDataSource.getPlayerProfile(ProfileKey.of(containerType, dataName, profileType, profile.getPlayerUUID(), profile.getLastKnownName())).thenCompose(playerProfile -> {
            if (playerProfile.getData().isEmpty()) {
                return CompletableFuture.completedFuture(null);
            }
            profileCounter.incrementAndGet();
            return this.profileDataSource.updatePlayerProfile((PlayerProfile)playerProfile);
        })))).toArray(CompletableFuture[]::new));
    }
}

