/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.handleshare;

import java.lang.annotation.Annotation;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.mvplugins.multiverse.inventories.MultiverseInventories;
import org.mvplugins.multiverse.inventories.config.InventoriesConfig;
import org.mvplugins.multiverse.inventories.event.ShareHandlingEvent;
import org.mvplugins.multiverse.inventories.handleshare.AffectedProfiles;
import org.mvplugins.multiverse.inventories.handleshare.PersistingProfile;
import org.mvplugins.multiverse.inventories.handleshare.ShareHandlingUpdater;
import org.mvplugins.multiverse.inventories.profile.ProfileDataSource;
import org.mvplugins.multiverse.inventories.profile.container.ProfileContainerStore;
import org.mvplugins.multiverse.inventories.profile.container.ProfileContainerStoreProvider;
import org.mvplugins.multiverse.inventories.profile.data.PlayerProfile;
import org.mvplugins.multiverse.inventories.profile.data.ProfileDataSnapshot;
import org.mvplugins.multiverse.inventories.profile.group.WorldGroupManager;
import org.mvplugins.multiverse.inventories.profile.key.ContainerType;
import org.mvplugins.multiverse.inventories.share.Sharables;
import org.mvplugins.multiverse.inventories.utils.InvLogging;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
abstract class ShareHandler {
    protected final Player player;
    protected final AffectedProfiles affectedProfiles;
    protected final MultiverseInventories inventories;
    protected final ProfileDataSource profileDataStore;
    protected final InventoriesConfig inventoriesConfig;
    protected final WorldGroupManager worldGroupManager;
    protected final ProfileContainerStore worldProfileContainerStore;

    ShareHandler(MultiverseInventories inventories, Player player) {
        this.player = player;
        this.affectedProfiles = new AffectedProfiles();
        this.inventories = inventories;
        this.profileDataStore = (ProfileDataSource)inventories.getServiceLocator().getService(ProfileDataSource.class, new Annotation[0]);
        this.inventoriesConfig = (InventoriesConfig)inventories.getServiceLocator().getService(InventoriesConfig.class, new Annotation[0]);
        this.worldGroupManager = (WorldGroupManager)inventories.getServiceLocator().getService(WorldGroupManager.class, new Annotation[0]);
        this.worldProfileContainerStore = ((ProfileContainerStoreProvider)inventories.getServiceLocator().getService(ProfileContainerStoreProvider.class, new Annotation[0])).getStore(ContainerType.WORLD);
    }

    public CompletableFuture<Void> handleSharing() {
        long startTime = System.nanoTime();
        this.prepareProfiles();
        ShareHandlingEvent event = this.createEvent();
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            InvLogging.fine("Share handling has been cancelled by another plugin!", new Object[0]);
            return CompletableFuture.completedFuture(null);
        }
        this.logAffectedProfilesCount();
        ProfileDataSnapshot snapshot = this.getSnapshot();
        this.updatePlayer();
        CompletableFuture<Void> future = this.updateProfiles(snapshot);
        double timeTaken = (double)(System.nanoTime() - startTime) / 1000000.0;
        this.logHandlingComplete(timeTaken, event);
        return future;
    }

    protected abstract void prepareProfiles();

    protected abstract ShareHandlingEvent createEvent();

    protected void logBypass() {
        InvLogging.fine(this.player.getName() + " has bypass permission for 1 or more world/groups!", new Object[0]);
    }

    private void logAffectedProfilesCount() {
        int writeProfiles = this.affectedProfiles.getWriteProfiles().size();
        InvLogging.finer("Change affected by %d fromProfiles and %d toProfiles", writeProfiles, this.affectedProfiles.getReadProfiles().size());
    }

    private ProfileDataSnapshot getSnapshot() {
        ProfileDataSnapshot profileDataSnapshot = new ProfileDataSnapshot();
        Sharables.enabled().forEach(sharable -> sharable.getHandler().updateProfile(profileDataSnapshot, this.player));
        return profileDataSnapshot;
    }

    private void updatePlayer() {
        for (PersistingProfile readProfile : this.affectedProfiles.getReadProfiles()) {
            ShareHandlingUpdater.updatePlayer(this.inventories, this.player, readProfile);
        }
    }

    private CompletableFuture<Void> updateProfiles(ProfileDataSnapshot snapshot) {
        if (this.affectedProfiles.getWriteProfiles().isEmpty()) {
            InvLogging.finest("No profiles to write - nothing more to do.", new Object[0]);
            return CompletableFuture.completedFuture(null);
        }
        return CompletableFuture.allOf((CompletableFuture[])this.affectedProfiles.getWriteProfiles().stream().map(writeProfile -> this.updatePersistingProfile((PersistingProfile)writeProfile, snapshot)).toArray(CompletableFuture[]::new));
    }

    private CompletableFuture<Void> updatePersistingProfile(PersistingProfile persistingProfile, ProfileDataSnapshot snapshot) {
        if (persistingProfile.getShares().isEmpty()) {
            InvLogging.finest("No shares to write - nothing more to do.", new Object[0]);
            return CompletableFuture.completedFuture(null);
        }
        return this.profileDataStore.getPlayerProfile(persistingProfile.getProfileKey()).thenCompose(playerProfile -> {
            InvLogging.finer("Persisted: " + String.valueOf(persistingProfile.getShares()) + " to " + String.valueOf((Object)playerProfile.getContainerType()) + ":" + playerProfile.getContainerName() + " (" + String.valueOf(playerProfile.getProfileType()) + ") for player " + playerProfile.getPlayerName(), new Object[0]);
            playerProfile.update(snapshot, persistingProfile.getShares());
            return this.profileDataStore.updatePlayerProfile((PlayerProfile)playerProfile);
        });
    }

    private void logHandlingComplete(double timeTaken, ShareHandlingEvent event) {
        InvLogging.fine("=== %s complete for %s | \u001b[32mtime taken: %4.4f ms\u001b[0m ===", this.player.getName(), event.getEventName(), timeTaken);
    }
}

