/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.listeners;

import java.util.List;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.core.dynamiclistener.annotations.DefaultEventPriority;
import org.mvplugins.multiverse.core.dynamiclistener.annotations.EventMethod;
import org.mvplugins.multiverse.core.world.LoadedMultiverseWorld;
import org.mvplugins.multiverse.core.world.WorldManager;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.inventories.listeners.MVInvListener;
import org.mvplugins.multiverse.inventories.profile.group.WorldGroup;
import org.mvplugins.multiverse.inventories.profile.group.WorldGroupManager;

@Service
final class RespawnListener
implements MVInvListener {
    private final WorldGroupManager worldGroupManager;
    private final WorldManager worldManager;
    private List<WorldGroup> currentGroups;
    private Location spawnLoc = null;

    @Inject
    RespawnListener(WorldGroupManager worldGroupManager, WorldManager worldManager) {
        this.worldGroupManager = worldGroupManager;
        this.worldManager = worldManager;
    }

    @EventMethod
    @DefaultEventPriority(value=EventPriority.LOWEST)
    void lowestPriorityRespawn(PlayerRespawnEvent event) {
        if (!event.isBedSpawn()) {
            World world = event.getPlayer().getWorld();
            this.currentGroups = this.worldGroupManager.getGroupsForWorld(world.getName());
            this.handleRespawn(event, EventPriority.LOWEST);
        }
    }

    @EventMethod
    @DefaultEventPriority(value=EventPriority.LOW)
    void lowPriorityRespawn(PlayerRespawnEvent event) {
        if (!event.isBedSpawn()) {
            this.handleRespawn(event, EventPriority.LOW);
        }
    }

    @EventMethod
    @DefaultEventPriority(value=EventPriority.NORMAL)
    void normalPriorityRespawn(PlayerRespawnEvent event) {
        if (!event.isBedSpawn()) {
            this.handleRespawn(event, EventPriority.NORMAL);
        }
    }

    @EventMethod
    @DefaultEventPriority(value=EventPriority.HIGH)
    void highPriorityRespawn(PlayerRespawnEvent event) {
        if (!event.isBedSpawn()) {
            this.handleRespawn(event, EventPriority.HIGH);
        }
    }

    @EventMethod
    @DefaultEventPriority(value=EventPriority.HIGHEST)
    void highestPriorityRespawn(PlayerRespawnEvent event) {
        if (!event.isBedSpawn()) {
            this.handleRespawn(event, EventPriority.HIGHEST);
        }
    }

    @EventMethod
    @DefaultEventPriority(value=EventPriority.MONITOR)
    void monitorPriorityRespawn(PlayerRespawnEvent event) {
        if (!event.isBedSpawn()) {
            this.handleRespawn(event, EventPriority.MONITOR);
            this.updateCompass(event);
        }
    }

    private void handleRespawn(PlayerRespawnEvent event, EventPriority priority) {
        for (WorldGroup group : this.currentGroups) {
            LoadedMultiverseWorld mvWorld;
            String spawnWorldName;
            if (!group.getSpawnPriority().equals((Object)priority) || (spawnWorldName = group.getSpawnWorld()) == null || (mvWorld = (LoadedMultiverseWorld)this.worldManager.getLoadedWorld(spawnWorldName).getOrNull()) == null) continue;
            this.spawnLoc = mvWorld.getSpawnLocation();
            event.setRespawnLocation(this.spawnLoc);
            break;
        }
    }

    private void updateCompass(PlayerRespawnEvent event) {
        if (event.getRespawnLocation().equals((Object)this.spawnLoc)) {
            event.getPlayer().setCompassTarget(this.spawnLoc);
        }
    }
}

