/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.listeners;

import com.google.common.base.Strings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityPortalEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.world.WorldUnloadEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.plugin.Plugin;
import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.core.dynamiclistener.annotations.DefaultEventPriority;
import org.mvplugins.multiverse.core.dynamiclistener.annotations.EventMethod;
import org.mvplugins.multiverse.core.dynamiclistener.annotations.IgnoreIfCancelled;
import org.mvplugins.multiverse.core.world.WorldManager;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.vavr.control.Try;
import org.mvplugins.multiverse.inventories.MultiverseInventories;
import org.mvplugins.multiverse.inventories.config.InventoriesConfig;
import org.mvplugins.multiverse.inventories.handleshare.GameModeShareHandler;
import org.mvplugins.multiverse.inventories.handleshare.ReadOnlyShareHandler;
import org.mvplugins.multiverse.inventories.handleshare.SingleShareWriter;
import org.mvplugins.multiverse.inventories.handleshare.WorldChangeShareHandler;
import org.mvplugins.multiverse.inventories.handleshare.WriteOnlyShareHandler;
import org.mvplugins.multiverse.inventories.listeners.MVInvListener;
import org.mvplugins.multiverse.inventories.profile.GlobalProfile;
import org.mvplugins.multiverse.inventories.profile.ProfileDataSource;
import org.mvplugins.multiverse.inventories.profile.container.ProfileContainer;
import org.mvplugins.multiverse.inventories.profile.container.ProfileContainerStoreProvider;
import org.mvplugins.multiverse.inventories.profile.data.PlayerProfile;
import org.mvplugins.multiverse.inventories.profile.group.WorldGroup;
import org.mvplugins.multiverse.inventories.profile.group.WorldGroupManager;
import org.mvplugins.multiverse.inventories.profile.key.ContainerType;
import org.mvplugins.multiverse.inventories.profile.key.GlobalProfileKey;
import org.mvplugins.multiverse.inventories.profile.key.ProfileKey;
import org.mvplugins.multiverse.inventories.profile.key.ProfileTypes;
import org.mvplugins.multiverse.inventories.share.Sharables;
import org.mvplugins.multiverse.inventories.util.FutureNow;
import org.mvplugins.multiverse.inventories.utils.InvLogging;

@Service
final class ShareHandleListener
implements MVInvListener {
    private final MultiverseInventories inventories;
    private final InventoriesConfig config;
    private final WorldManager worldManager;
    private final WorldGroupManager worldGroupManager;
    private final ProfileDataSource profileDataSource;
    private final ProfileContainerStoreProvider profileContainerStoreProvider;

    @Inject
    ShareHandleListener(@NotNull MultiverseInventories inventories, InventoriesConfig config, @NotNull WorldManager worldManager, @NotNull WorldGroupManager worldGroupManager, @NotNull ProfileDataSource profileDataSource, @NotNull ProfileContainerStoreProvider profileContainerStoreProvider) {
        this.inventories = inventories;
        this.config = config;
        this.worldManager = worldManager;
        this.worldGroupManager = worldGroupManager;
        this.profileDataSource = profileDataSource;
        this.profileContainerStoreProvider = profileContainerStoreProvider;
    }

    @EventMethod
    @DefaultEventPriority(value=EventPriority.MONITOR)
    void playerPreLogin(AsyncPlayerPreLoginEvent event) {
        if (event.getLoginResult() != AsyncPlayerPreLoginEvent.Result.ALLOWED) {
            return;
        }
        InvLogging.finer("Loading global profile for Player{name:'%s', uuid:'%s'}.", event.getName(), event.getUniqueId());
        this.verifyCorrectPlayerName(event.getUniqueId(), event.getName());
        long startTime = System.nanoTime();
        ArrayList profileFutures = new ArrayList();
        this.config.getPreloadDataOnJoinWorlds().forEach(worldName -> profileFutures.add(this.profileDataSource.getPlayerProfile(ProfileKey.of(ContainerType.WORLD, worldName, ProfileTypes.SURVIVAL, event.getUniqueId(), event.getName()))));
        this.config.getPreloadDataOnJoinGroups().forEach(groupName -> profileFutures.add(this.profileDataSource.getPlayerProfile(ProfileKey.of(ContainerType.GROUP, groupName, ProfileTypes.SURVIVAL, event.getUniqueId(), event.getName()))));
        Try.run(() -> CompletableFuture.allOf(profileFutures.toArray(new CompletableFuture[0])).get(10L, TimeUnit.SECONDS)).onSuccess(ignore -> InvLogging.finer("Preloaded data for Player{name:'%s', uuid:'%s'}. Time taken: %4.4f ms", event.getName(), event.getUniqueId(), (double)(System.nanoTime() - startTime) / 1000000.0)).onFailure(e -> InvLogging.warning("Preload data errored out: %s", e.getMessage()));
    }

    @EventMethod
    void playerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        this.verifyCorrectPlayerName(player.getUniqueId(), player.getName());
        GlobalProfile globalProfile = FutureNow.get(this.profileDataSource.getGlobalProfile(GlobalProfileKey.of((OfflinePlayer)player)));
        if (globalProfile.shouldLoadOnLogin()) {
            new ReadOnlyShareHandler(this.inventories, player).handleSharing();
        }
        globalProfile.setLoadOnLogin(false);
        this.verifyCorrectWorld(player, player.getWorld().getName(), globalProfile);
        this.profileDataSource.updateGlobalProfile(globalProfile);
    }

    private void verifyCorrectPlayerName(UUID uuid, String name) {
        FutureNow.get(this.profileDataSource.getExistingGlobalProfile(GlobalProfileKey.of(uuid, name))).peek(globalProfile -> {
            if (globalProfile.getLastKnownName().equals(name)) {
                return;
            }
            InvLogging.info("Player %s changed name from '%s' to '%s'. Attempting to migrate playerdata...", uuid, globalProfile.getLastKnownName(), name);
            try {
                this.profileDataSource.migratePlayerProfileName(globalProfile.getLastKnownName(), name);
            }
            catch (IOException e) {
                InvLogging.severe("An error occurred while trying to migrate playerdata.", new Object[0]);
                e.printStackTrace();
            }
            globalProfile.setLastKnownName(name);
            this.profileDataSource.updateGlobalProfile((GlobalProfile)globalProfile);
            InvLogging.info("Migration complete!", new Object[0]);
        });
    }

    @EventMethod
    void playerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        String world = event.getPlayer().getWorld().getName();
        CompletableFuture<GlobalProfile> globalProfile = this.profileDataSource.getGlobalProfile(GlobalProfileKey.of((OfflinePlayer)player));
        globalProfile.thenAccept(p -> p.setLastWorld(world));
        SingleShareWriter.of(this.inventories, player, Sharables.LAST_LOCATION).write(player.getLocation().clone());
        new WriteOnlyShareHandler(this.inventories, player).handleSharing();
        if (this.config.getApplyPlayerdataOnJoin()) {
            globalProfile.thenAccept(p -> p.setLoadOnLogin(true));
        }
        globalProfile.thenAccept(this.profileDataSource::updateGlobalProfile);
    }

    private void verifyCorrectWorld(Player player, String world, GlobalProfile globalProfile) {
        if (Strings.isNullOrEmpty((String)globalProfile.getLastWorld())) {
            globalProfile.setLastWorld(world);
        } else if (!world.equals(globalProfile.getLastWorld())) {
            InvLogging.fine("Player did not spawn in the world they were last reported to be in!", new Object[0]);
            new WorldChangeShareHandler(this.inventories, player, globalProfile.getLastWorld(), world).handleSharing();
            globalProfile.setLastWorld(world);
        }
    }

    @EventMethod
    @DefaultEventPriority(value=EventPriority.MONITOR)
    void playerGameModeChange(PlayerGameModeChangeEvent event) {
        if (event.isCancelled() || !this.config.getEnableGamemodeShareHandling()) {
            return;
        }
        Player player = event.getPlayer();
        SingleShareWriter.of(this.inventories, player, Sharables.LAST_LOCATION).write(player.getLocation().clone());
        new GameModeShareHandler(this.inventories, player, player.getGameMode(), event.getNewGameMode()).handleSharing();
    }

    @EventMethod
    @DefaultEventPriority(value=EventPriority.LOW)
    void playerChangedWorld(PlayerChangedWorldEvent event) {
        World toWorld;
        Player player = event.getPlayer();
        World fromWorld = event.getFrom();
        if (fromWorld.equals((Object)(toWorld = player.getWorld()))) {
            InvLogging.fine("PlayerChangedWorldEvent fired when player travelling in same world.", new Object[0]);
            return;
        }
        if (!this.worldManager.isLoadedWorld(toWorld) || !this.worldManager.isLoadedWorld(fromWorld)) {
            InvLogging.fine("The from or to world is not managed by Multiverse-Core!", new Object[0]);
        }
        new WorldChangeShareHandler(this.inventories, player, fromWorld.getName(), toWorld.getName()).handleSharing();
        this.profileDataSource.modifyGlobalProfile(GlobalProfileKey.of((OfflinePlayer)player), profile -> profile.setLastWorld(toWorld.getName()));
    }

    @EventMethod
    @DefaultEventPriority(value=EventPriority.MONITOR)
    void playerTeleport(PlayerTeleportEvent event) {
        if (event.isCancelled() || event.getFrom().getWorld().equals((Object)event.getTo().getWorld()) || !this.config.getActiveOptionalShares().contains(Sharables.LAST_LOCATION)) {
            return;
        }
        Player player = event.getPlayer();
        SingleShareWriter.of(this.inventories, player, Sharables.LAST_LOCATION).write(event.getFrom().clone());
        player.closeInventory();
    }

    @EventMethod
    @DefaultEventPriority(value=EventPriority.MONITOR)
    void playerDeath(PlayerDeathEvent event) {
        InvLogging.finer("=== Handling PlayerDeathEvent for: " + event.getEntity().getName() + " ===", new Object[0]);
        String deathWorld = event.getEntity().getWorld().getName();
        ProfileContainer worldProfileContainer = this.profileContainerStoreProvider.getStore(ContainerType.WORLD).getContainer(deathWorld);
        PlayerProfile profile = worldProfileContainer.getPlayerProfileNow(event.getEntity());
        this.resetStatsOnDeath(event, profile);
        for (WorldGroup worldGroup : this.worldGroupManager.getGroupsForWorld(deathWorld)) {
            profile = worldGroup.getGroupProfileContainer().getPlayerProfileNow(event.getEntity());
            this.resetStatsOnDeath(event, profile);
        }
        InvLogging.finer("=== Finished handling PlayerDeathEvent for: " + event.getEntity().getName() + "! ===", new Object[0]);
    }

    private void resetStatsOnDeath(PlayerDeathEvent event, PlayerProfile profile) {
        profile.set(Sharables.LEVEL, event.getNewLevel());
        profile.set(Sharables.EXPERIENCE, Float.valueOf(event.getNewExp()));
        profile.set(Sharables.TOTAL_EXPERIENCE, event.getNewTotalExp());
        if (this.config.getResetLastLocationOnDeath()) {
            profile.set(Sharables.LAST_LOCATION, null);
        }
        this.profileDataSource.updatePlayerProfile(profile);
    }

    @EventMethod
    @DefaultEventPriority(value=EventPriority.MONITOR)
    void playerRespawn(PlayerRespawnEvent event) {
        Location respawnLoc = event.getRespawnLocation();
        if (respawnLoc == null) {
            return;
        }
        Player player = event.getPlayer();
        Bukkit.getScheduler().runTaskLater((Plugin)this.inventories, () -> this.verifyCorrectWorld(player, player.getWorld().getName(), FutureNow.get(this.profileDataSource.getGlobalProfile(GlobalProfileKey.of((OfflinePlayer)player)))), 2L);
    }

    @EventMethod
    @IgnoreIfCancelled
    @DefaultEventPriority(value=EventPriority.HIGH)
    void entityPortal(EntityPortalEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Item) && !(entity instanceof InventoryHolder)) {
            return;
        }
        World fromWorld = event.getFrom().getWorld();
        if (fromWorld == null) {
            InvLogging.fine("Entity %s attempted to go from null world", entity);
            return;
        }
        Location toLocation = event.getTo();
        if (toLocation == null) {
            InvLogging.fine("Entity %s attempted to go to null location", entity);
            return;
        }
        World toWorld = toLocation.getWorld();
        if (toWorld == null) {
            InvLogging.fine("Entity %s attempted to go to null world", entity);
            return;
        }
        if (fromWorld.equals((Object)toWorld)) {
            return;
        }
        List<WorldGroup> fromGroups = this.worldGroupManager.getGroupsForWorld(fromWorld.getName());
        List<WorldGroup> toGroups = this.worldGroupManager.getGroupsForWorld(toWorld.getName());
        fromGroups = fromGroups.stream().filter(it -> it.isSharing(Sharables.INVENTORY)).toList();
        toGroups = toGroups.stream().filter(it -> it.isSharing(Sharables.INVENTORY)).toList();
        for (WorldGroup fromGroup : fromGroups) {
            if (!toGroups.contains(fromGroup)) continue;
            InvLogging.finest("Allowing item or inventory holding %s to go from world %s to world %s", entity, fromWorld.getName(), toWorld.getName());
            return;
        }
        InvLogging.finest("Disallowing item or inventory holding %s to go from world %s to world %s since theseworlds do not share inventories", entity, fromWorld.getName(), toWorld.getName());
        event.setCancelled(true);
    }

    @EventMethod
    void worldUnload(WorldUnloadEvent event) {
        String unloadWorldName = event.getWorld().getName();
        InvLogging.finer("Clearing data for world/groups container with '%s' world.", unloadWorldName);
        ProfileContainer fromWorldProfileContainer = this.profileContainerStoreProvider.getStore(ContainerType.WORLD).getContainer(unloadWorldName);
        fromWorldProfileContainer.clearContainerCache();
        List<WorldGroup> fromGroups = this.worldGroupManager.getGroupsForWorld(unloadWorldName);
        for (WorldGroup fromGroup : fromGroups) {
            fromGroup.getGroupProfileContainer().clearContainerCache();
        }
    }
}

