/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.profile.bulkedit;

import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public final class BulkEditResult {
    private final long startTime = System.nanoTime();
    private final AtomicInteger successCount = new AtomicInteger(0);
    private final AtomicInteger failureCount = new AtomicInteger(0);

    BulkEditResult() {
    }

    void incrementSuccess() {
        this.successCount.incrementAndGet();
    }

    void incrementFailure() {
        this.failureCount.incrementAndGet();
    }

    public int getSuccessCount() {
        return this.successCount.get();
    }

    public int getFailureCount() {
        return this.failureCount.get();
    }

    public double getTimeTaken() {
        return (double)(System.nanoTime() - this.startTime) / 1000000.0;
    }
}

