/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.profile.bulkedit;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import org.mvplugins.multiverse.inventories.MultiverseInventories;
import org.mvplugins.multiverse.inventories.profile.bulkedit.BulkEditAction;
import org.mvplugins.multiverse.inventories.profile.bulkedit.PlayerProfilesAggregator;
import org.mvplugins.multiverse.inventories.profile.bulkedit.PlayerProfilesPayload;
import org.mvplugins.multiverse.inventories.profile.key.ProfileKey;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
abstract class PlayerProfileAction
extends BulkEditAction<ProfileKey> {
    private final PlayerProfilesAggregator profilesAggregator;
    private final PlayerProfilesPayload bulkProfilesPayload;

    protected PlayerProfileAction(MultiverseInventories inventories, PlayerProfilesPayload bulkProfilesPayload) {
        super(inventories, bulkProfilesPayload.globalProfileKeys());
        this.profilesAggregator = (PlayerProfilesAggregator)inventories.getServiceLocator().getService(PlayerProfilesAggregator.class, new Annotation[0]);
        this.bulkProfilesPayload = bulkProfilesPayload;
    }

    @Override
    protected List<ProfileKey> aggregateKeys() {
        return this.profilesAggregator.getPlayerProfileKeys(this.bulkProfilesPayload);
    }

    @Override
    public Map<String, List<String>> getActionSummary() {
        return this.bulkProfilesPayload.getSummary();
    }
}

