/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.profile.bulkedit;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.inventories.profile.bulkedit.PlayerProfilesPayload;
import org.mvplugins.multiverse.inventories.profile.group.WorldGroup;
import org.mvplugins.multiverse.inventories.profile.group.WorldGroupManager;
import org.mvplugins.multiverse.inventories.profile.key.ContainerKey;
import org.mvplugins.multiverse.inventories.profile.key.ContainerType;
import org.mvplugins.multiverse.inventories.profile.key.GlobalProfileKey;
import org.mvplugins.multiverse.inventories.profile.key.ProfileFileKey;
import org.mvplugins.multiverse.inventories.profile.key.ProfileKey;
import org.mvplugins.multiverse.inventories.profile.key.ProfileType;

@Service
final class PlayerProfilesAggregator {
    private final WorldGroupManager worldGroupManager;

    @Inject
    PlayerProfilesAggregator(WorldGroupManager worldGroupManager) {
        this.worldGroupManager = worldGroupManager;
    }

    List<ProfileFileKey> getProfileFileKeys(PlayerProfilesPayload payload) {
        ContainerKey[] containerKeys = payload.includeGroupsWorlds() ? this.includeGroupsWorlds(payload.containerKeys()) : payload.containerKeys();
        ArrayList<ProfileFileKey> profileFileKeys = new ArrayList<ProfileFileKey>(payload.globalProfileKeys().length * containerKeys.length);
        for (GlobalProfileKey globalProfileKey : payload.globalProfileKeys()) {
            for (ContainerKey containerKey : containerKeys) {
                profileFileKeys.add(ProfileFileKey.of(containerKey.getContainerType(), containerKey.getDataName(), globalProfileKey.getPlayerUUID(), globalProfileKey.getPlayerName()));
            }
        }
        return profileFileKeys;
    }

    List<ProfileKey> getPlayerProfileKeys(PlayerProfilesPayload payload) {
        ContainerKey[] containerKeys = payload.includeGroupsWorlds() ? this.includeGroupsWorlds(payload.containerKeys()) : payload.containerKeys();
        ArrayList<ProfileKey> profileKeys = new ArrayList<ProfileKey>(payload.globalProfileKeys().length * containerKeys.length * payload.profileTypes().length);
        for (GlobalProfileKey globalProfileKey : payload.globalProfileKeys()) {
            for (ContainerKey containerKey : containerKeys) {
                for (ProfileType profileType : payload.profileTypes()) {
                    profileKeys.add(ProfileKey.of(containerKey.getContainerType(), containerKey.getDataName(), profileType, globalProfileKey.getPlayerUUID(), globalProfileKey.getPlayerName()));
                }
            }
        }
        return profileKeys;
    }

    private ContainerKey[] includeGroupsWorlds(ContainerKey[] containerKeys) {
        HashSet containerKeyList = Sets.newHashSet((Object[])containerKeys);
        for (ContainerKey containerKey : containerKeys) {
            WorldGroup group;
            if (containerKey.getContainerType() != ContainerType.GROUP || (group = this.worldGroupManager.getGroup(containerKey.getDataName())) == null) continue;
            containerKeyList.addAll(group.getWorlds().stream().map(worldName -> ContainerKey.create(ContainerType.WORLD, worldName)).toList());
        }
        return (ContainerKey[])containerKeyList.toArray(ContainerKey[]::new);
    }
}

