/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.portals;

import com.sk89q.worldedit.math.BlockVector3;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.bukkit.util.Vector;
import org.mvplugins.multiverse.core.MultiverseCoreApi;
import org.mvplugins.multiverse.core.world.LoadedMultiverseWorld;
import org.mvplugins.multiverse.portals.util.MVPLogging;
import org.mvplugins.multiverse.portals.utils.MultiverseRegion;

public class PortalLocation {
    private MultiverseRegion region;
    private boolean validLocation = false;

    public static PortalLocation parseLocation(String locationString) {
        String[] split = locationString.split(":");
        if (split.length != 3) {
            MVPLogging.warning("Failed Parsing Location (Format Error, was expecting: `WORLD:X,Y,Z:X,Y,Z`, but got: `" + locationString + "`)", new Object[0]);
            return PortalLocation.getInvalidPortalLocation();
        }
        String worldName = split[0];
        LoadedMultiverseWorld world = (LoadedMultiverseWorld)MultiverseCoreApi.get().getWorldManager().getLoadedWorld(worldName).getOrNull();
        if (world == null) {
            MVPLogging.warning("Failed Parsing World (World Error, World did not exist or was not imported into Multiverse-Core!)", new Object[0]);
            return PortalLocation.getInvalidPortalLocation();
        }
        Vector pos1 = PortalLocation.parseVector(split[1]);
        Vector pos2 = PortalLocation.parseVector(split[2]);
        if (pos1 == null || pos2 == null) {
            MVPLogging.warning("Failed Parsing Location (Vector Error, was expecting: `WORLD:X,Y,Z:X,Y,Z`, but got: `" + locationString + "`)", new Object[0]);
            return PortalLocation.getInvalidPortalLocation();
        }
        return new PortalLocation(pos1, pos2, world);
    }

    public static PortalLocation parseLocation(String locationString, LoadedMultiverseWorld world, String portalName) {
        String[] split = locationString.split(":");
        if (split.length != 2) {
            MVPLogging.warning("Failed Parsing Location for: " + portalName + " (Format Error, was expecting: `X,Y,Z:X,Y,Z`, but got: `" + locationString + "`)", new Object[0]);
            return PortalLocation.getInvalidPortalLocation();
        }
        if (world == null) {
            MVPLogging.warning("Failed Parsing World for: " + portalName + " (World Error, World did not exist or was not imported into Multiverse-Core!)", new Object[0]);
            return PortalLocation.getInvalidPortalLocation();
        }
        Vector pos1 = PortalLocation.parseVector(split[0]);
        Vector pos2 = PortalLocation.parseVector(split[1]);
        if (pos1 == null || pos2 == null) {
            MVPLogging.warning("Failed Parsing Location for: " + portalName + " (Vector Error, was expecting: `X,Y,Z:X,Y,Z`, but got: `" + locationString + "`)", new Object[0]);
            return PortalLocation.getInvalidPortalLocation();
        }
        return new PortalLocation(pos1, pos2, world);
    }

    private static PortalLocation getInvalidPortalLocation() {
        return new PortalLocation();
    }

    public PortalLocation() {
    }

    public PortalLocation(Vector pos1, Vector pos2, LoadedMultiverseWorld world) {
        this.validLocation = this.setLocation(pos1, pos2, world);
    }

    public PortalLocation(BlockVector3 minPt, BlockVector3 maxPt, LoadedMultiverseWorld world) {
        this(new Vector(minPt.getX(), minPt.getY(), minPt.getZ()), new Vector(maxPt.getX(), maxPt.getY(), maxPt.getZ()), world);
    }

    private static Vector parseVector(String vectorString) {
        String[] stringCoords = vectorString.split(",");
        double[] coords = new double[3];
        for (int i = 0; i < 3; ++i) {
            try {
                coords[i] = Double.parseDouble(stringCoords[i]);
                continue;
            }
            catch (NumberFormatException e) {
                coords[i] = 0.0;
                return null;
            }
        }
        return new Vector(coords[0], coords[1], coords[2]);
    }

    public boolean setLocation(Vector v1, Vector v2, LoadedMultiverseWorld world) {
        if (v1 == null || v2 == null || world == null) {
            this.validLocation = false;
            this.region = null;
        } else {
            this.validLocation = true;
            this.region = new MultiverseRegion(v1, v2, world);
        }
        return this.validLocation;
    }

    public boolean setLocation(String v1, String v2, LoadedMultiverseWorld world) {
        if (v1 == null || v2 == null) {
            this.validLocation = false;
            this.region = null;
            return false;
        }
        return this.setLocation(PortalLocation.parseVector(v1), PortalLocation.parseVector(v2), world);
    }

    public boolean isValidLocation() {
        return this.validLocation;
    }

    public List<Vector> getVectors() {
        return Arrays.asList(this.region.getMinimumPoint(), this.region.getMaximumPoint());
    }

    public Vector getMinimum() {
        return this.region.getMinimumPoint();
    }

    public Vector getMaximum() {
        return this.region.getMaximumPoint();
    }

    @Nullable
    public LoadedMultiverseWorld getMVWorld() {
        if (this.region == null) {
            return null;
        }
        return this.region.getWorld();
    }

    @Nullable
    public MultiverseRegion getRegion() {
        return this.region;
    }

    public String toString() {
        return this.region == null ? "" : this.region.toString();
    }
}

