/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.portals;

import com.sk89q.worldedit.IncompleteRegionException;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.bukkit.BukkitPlayer;
import com.sk89q.worldedit.bukkit.BukkitWorld;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.session.SessionOwner;
import com.sk89q.worldedit.world.World;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class WorldEditConnection {
    private final Plugin connectingPlugin;
    private WorldEditPlugin worldEditPlugin;
    WorldEdit worldEdit;

    WorldEditConnection(Plugin plugin) {
        if (plugin == null) {
            throw new RuntimeException("plugin must not be null.");
        }
        this.connectingPlugin = plugin;
    }

    private WorldEditPlugin retrieveWorldEditPluginFromServer() {
        Plugin plugin = this.connectingPlugin.getServer().getPluginManager().getPlugin("WorldEdit");
        if (plugin == null) {
            plugin = this.connectingPlugin.getServer().getPluginManager().getPlugin("FastAsyncWorldEdit");
        }
        if (plugin == null) {
            return null;
        }
        if (plugin instanceof WorldEditPlugin) {
            return (WorldEditPlugin)plugin;
        }
        this.connectingPlugin.getLogger().warning("WorldEdit v" + plugin.getDescription().getVersion() + " is incompatible with " + this.connectingPlugin.getDescription().getName() + " v" + this.connectingPlugin.getDescription().getVersion());
        return null;
    }

    boolean connect() {
        if (!this.isConnected()) {
            this.worldEditPlugin = this.retrieveWorldEditPluginFromServer();
            if (this.worldEditPlugin != null) {
                this.worldEdit = this.worldEditPlugin.getWorldEdit();
                this.connectingPlugin.getLogger().info(String.format("Found %s. Using it for selections.", this.worldEditPlugin.getName()));
                return true;
            }
        }
        return false;
    }

    void disconnect() {
        this.worldEditPlugin = null;
        this.worldEdit = null;
    }

    public boolean isConnected() {
        return this.worldEditPlugin != null;
    }

    private Region getSelection(Player player) {
        if (!this.isConnected()) {
            throw new RuntimeException("WorldEdit connection is unavailable.");
        }
        try {
            return this.worldEdit.getSessionManager().get((SessionOwner)new BukkitPlayer(this.worldEditPlugin, player)).getSelection((World)new BukkitWorld(player.getWorld()));
        }
        catch (IncompleteRegionException e) {
            return null;
        }
    }

    public Location getSelectionMaxPoint(Player player) {
        if (player == null) {
            throw new RuntimeException("player must not be null.");
        }
        if (!this.isConnected()) {
            throw new RuntimeException("WorldEdit connection is unavailable.");
        }
        Region selection = this.getSelection(player);
        if (selection != null) {
            BlockVector3 point = selection.getMaximumPoint();
            return new Location(player.getWorld(), (double)point.getBlockX(), (double)point.getBlockY(), (double)point.getBlockZ());
        }
        return null;
    }

    public Location getSelectionMinPoint(Player player) {
        if (player == null) {
            throw new RuntimeException("player must not be null.");
        }
        if (!this.isConnected()) {
            throw new RuntimeException("WorldEdit connection is unavailable.");
        }
        Region selection = this.getSelection(player);
        if (selection != null) {
            BlockVector3 point = selection.getMinimumPoint();
            return new Location(player.getWorld(), (double)point.getBlockX(), (double)point.getBlockY(), (double)point.getBlockZ());
        }
        return null;
    }

    public boolean isSelectionAvailable(Player player) {
        if (player == null) {
            throw new RuntimeException("player must not be null.");
        }
        if (!this.isConnected()) {
            throw new RuntimeException("WorldEdit connection is unavailable.");
        }
        return this.getSelection(player) != null;
    }
}

