/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.portals.config;

import java.nio.file.Path;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.core.config.handle.BaseConfigurationHandle;
import org.mvplugins.multiverse.core.config.handle.CommentedConfigurationHandle;
import org.mvplugins.multiverse.core.config.handle.StringPropertyHandle;
import org.mvplugins.multiverse.core.config.migration.ConfigMigrator;
import org.mvplugins.multiverse.core.config.migration.VersionMigrator;
import org.mvplugins.multiverse.core.config.migration.action.MigratorAction;
import org.mvplugins.multiverse.core.config.migration.action.MoveMigratorAction;
import org.mvplugins.multiverse.core.config.node.NodeGroup;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.vavr.control.Try;
import org.mvplugins.multiverse.portals.MultiversePortals;
import org.mvplugins.multiverse.portals.config.PortalsConfigNodes;
import org.mvplugins.multiverse.portals.util.MVPLogging;

@Service
@ApiStatus.AvailableSince(value="5.1")
public final class PortalsConfig {
    public static final String CONFIG_FILENAME = "config.yml";
    private final Path configPath;
    private final PortalsConfigNodes configNodes;
    private final CommentedConfigurationHandle configHandle;
    private final StringPropertyHandle stringPropertyHandle;

    @Inject
    PortalsConfig(@NotNull MultiversePortals plugin, @NotNull PortalsConfigNodes configNodes) {
        this.configPath = Path.of(plugin.getDataFolder().getPath(), CONFIG_FILENAME);
        this.configNodes = configNodes;
        this.configHandle = ((CommentedConfigurationHandle.Builder)((CommentedConfigurationHandle.Builder)CommentedConfigurationHandle.builder((Path)this.configPath, (NodeGroup)configNodes.getNodes()).logger(MVPLogging.getLogger())).migrator(ConfigMigrator.builder(configNodes.version).addVersionMigrator(VersionMigrator.builder((double)5.0).addAction((MigratorAction)MoveMigratorAction.of((String)"wand", (String)"portal-creation.wand-material")).addAction((MigratorAction)MoveMigratorAction.of((String)"useronmove", (String)"portal-usage.use-on-move")).addAction((MigratorAction)MoveMigratorAction.of((String)"bucketfilling", (String)"portal-creation.bucket-filling")).addAction((MigratorAction)MoveMigratorAction.of((String)"portalsdefaulttonether", (String)"portal-usage.portals-default-to-nether")).addAction((MigratorAction)MoveMigratorAction.of((String)"enforceportalaccess", (String)"portal-usage.enforce-portal-access")).addAction((MigratorAction)MoveMigratorAction.of((String)"portalcooldown", (String)"portal-usage.portal-cooldown")).addAction((MigratorAction)MoveMigratorAction.of((String)"clearonremove", (String)"portal-creation.clear-on-remove")).addAction((MigratorAction)MoveMigratorAction.of((String)"teleportvehicles", (String)"portal-usage.teleport-vehicles")).addAction((MigratorAction)MoveMigratorAction.of((String)"netheranimation", (String)"portal-usage.nether-animation")).addAction((MigratorAction)MoveMigratorAction.of((String)"framematerials", (String)"portal-creation.frame-materials")).build()).build())).build();
        this.stringPropertyHandle = new StringPropertyHandle((BaseConfigurationHandle)this.configHandle);
    }

    public Try<Void> load() {
        return this.configHandle.load().onFailure(e -> {
            MVPLogging.severe("Failed to load Multiverse-Core config.yml!", new Object[0]);
            e.printStackTrace();
        });
    }

    public boolean isLoaded() {
        return this.configHandle.isLoaded();
    }

    public Try<Void> save() {
        return this.configHandle.save().onFailure(e -> {
            MVPLogging.severe("Failed to save Multiverse-Core config.yml!", new Object[0]);
            e.printStackTrace();
        });
    }

    @ApiStatus.AvailableSince(value="5.1")
    public StringPropertyHandle getStringPropertyHandle() {
        return this.stringPropertyHandle;
    }

    @ApiStatus.AvailableSince(value="5.1")
    public Material getWandMaterial() {
        return (Material)this.configHandle.get(this.configNodes.wandMaterial);
    }

    @ApiStatus.AvailableSince(value="5.1")
    public Try<Void> setWandMaterial(Material wand) {
        return this.configHandle.set(this.configNodes.wandMaterial, (Object)wand);
    }

    @ApiStatus.AvailableSince(value="5.1")
    public boolean getBucketFilling() {
        return (Boolean)this.configHandle.get(this.configNodes.bucketFilling);
    }

    @ApiStatus.AvailableSince(value="5.1")
    public Try<Void> setBucketFilling(boolean bucketFilling) {
        return this.configHandle.set(this.configNodes.bucketFilling, (Object)bucketFilling);
    }

    @ApiStatus.AvailableSince(value="5.1")
    public List<Material> getFrameMaterials() {
        return (List)this.configHandle.get(this.configNodes.frameMaterials);
    }

    @ApiStatus.AvailableSince(value="5.1")
    public Try<Void> setFrameMaterials(List<Material> frameMaterials) {
        return this.configHandle.set(this.configNodes.frameMaterials, frameMaterials);
    }

    @ApiStatus.AvailableSince(value="5.1")
    public boolean getClearOnRemove() {
        return (Boolean)this.configHandle.get(this.configNodes.clearOnRemove);
    }

    @ApiStatus.AvailableSince(value="5.1")
    public Try<Void> setClearOnRemove(boolean clearOnRemove) {
        return this.configHandle.set(this.configNodes.clearOnRemove, (Object)clearOnRemove);
    }

    @ApiStatus.AvailableSince(value="5.1")
    public boolean getEnforcePortalAccess() {
        return (Boolean)this.configHandle.get(this.configNodes.enforcePortalAccess);
    }

    @ApiStatus.AvailableSince(value="5.1")
    public Try<Void> setEnforcePortalAccess(boolean enforcePortalAccess) {
        return this.configHandle.set(this.configNodes.enforcePortalAccess, (Object)enforcePortalAccess);
    }

    @ApiStatus.AvailableSince(value="5.1")
    public int getPortalCooldown() {
        return (Integer)this.configHandle.get(this.configNodes.portalCooldown);
    }

    @ApiStatus.AvailableSince(value="5.1")
    public Try<Void> setPortalCooldown(int portalCooldown) {
        return this.configHandle.set(this.configNodes.portalCooldown, (Object)portalCooldown);
    }

    @ApiStatus.AvailableSince(value="5.1")
    public boolean getPortalsDefaultToNether() {
        return (Boolean)this.configHandle.get(this.configNodes.portalsDefaultToNether);
    }

    @ApiStatus.AvailableSince(value="5.1")
    public Try<Void> setPortalsDefaultToNether(boolean portalsDefaultToNether) {
        return this.configHandle.set(this.configNodes.portalsDefaultToNether, (Object)portalsDefaultToNether);
    }

    @ApiStatus.AvailableSince(value="5.1")
    public boolean getNetherAnimation() {
        return (Boolean)this.configHandle.get(this.configNodes.netherAnimation);
    }

    @ApiStatus.AvailableSince(value="5.1")
    public Try<Void> setNetherAnimation(boolean netherAnimation) {
        return this.configHandle.set(this.configNodes.netherAnimation, (Object)netherAnimation);
    }

    @ApiStatus.AvailableSince(value="5.1")
    public boolean getTeleportVehicles() {
        return (Boolean)this.configHandle.get(this.configNodes.teleportVehicles);
    }

    @ApiStatus.AvailableSince(value="5.1")
    public Try<Void> setTeleportVehicles(boolean teleportVehicles) {
        return this.configHandle.set(this.configNodes.teleportVehicles, (Object)teleportVehicles);
    }

    @ApiStatus.AvailableSince(value="5.1")
    public boolean getUseOnMove() {
        return (Boolean)this.configHandle.get(this.configNodes.useOnMove);
    }

    @ApiStatus.AvailableSince(value="5.1")
    public Try<Void> setUseOnMove(boolean useOnMove) {
        return this.configHandle.set(this.configNodes.useOnMove, (Object)useOnMove);
    }

    @Deprecated(since="5.1", forRemoval=true)
    @ApiStatus.AvailableSince(value="5.1")
    @ApiStatus.ScheduledForRemoval(inVersion="6.0")
    public FileConfiguration getConfig() {
        return (FileConfiguration)this.configHandle.getConfig();
    }
}

