/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.portals.config;

import java.util.ArrayList;
import org.bukkit.Material;
import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.core.config.node.ConfigHeaderNode;
import org.mvplugins.multiverse.core.config.node.ConfigNode;
import org.mvplugins.multiverse.core.config.node.ListConfigNode;
import org.mvplugins.multiverse.core.config.node.Node;
import org.mvplugins.multiverse.core.config.node.NodeGroup;
import org.mvplugins.multiverse.core.config.node.serializer.NodeSerializer;
import org.mvplugins.multiverse.core.utils.MaterialConverter;
import org.mvplugins.multiverse.portals.MultiversePortals;

@Service
final class PortalsConfigNodes {
    private final NodeGroup nodes = new NodeGroup();
    private final ConfigHeaderNode portalCreationHeader = this.node(ConfigHeaderNode.builder((String)"portal-creation").comment("#-------------------------------------------------------------------------------------------------------#").comment("#                                                                                                       #").comment("#          __  __ _   _ _  _____ _____   _____ ___  ___ ___   ___  ___  ___ _____ _   _    ___          #").comment("#         |  \\/  | | | | ||_   _|_ _\\ \\ / / __| _ \\/ __| __| | _ \\/ _ \\| _ \\_   _/_\\ | |  / __|         #").comment("#         | |\\/| | |_| | |__| |  | | \\ V /| _||   /\\__ \\ _|  |  _/ (_) |   / | |/ _ \\| |__\\__ \\         #").comment("#         |_|  |_|\\___/|____|_| |___| \\_/ |___|_|_\\|___/___| |_|  \\___/|_|_\\ |_/_/ \\_\\____|___/         #").comment("#                                                                                                       #").comment("#                                                                                                       #").comment("#               WIKI:        https://mvplugins.org/portals/fundamentals/basic-usage/                    #").comment("#               DISCORD:     https://discord.gg/NZtfKky                                                 #").comment("#               BUG REPORTS: https://github.com/Multiverse/Multiverse-Portals/issues                    #").comment("#                                                                                                       #").comment("#                                                                                                       #").comment("#           New options are added to this file automatically. If you manually made changes              #").comment("#           to this file while your server is running, please run `/mvp reload` command.                #").comment("#                                                                                                       #").comment("#-------------------------------------------------------------------------------------------------------#").comment("").comment("").build());
    final ConfigNode<Material> wandMaterial = this.node(((ConfigNode.Builder)((ConfigNode.Builder)ConfigNode.builder((String)"portal-creation.wand-material", Material.class).comment("The item used to select a region to create a mvportal. Run `/mv wand` to start selection.")).comment("This will be ignore if worldedit is used for selection instead.")).defaultValue((Object)Material.WOODEN_PICKAXE).name("wand-material").serializer((NodeSerializer)new NodeSerializer<Material>(){

        public Material deserialize(Object o, Class<Material> aClass) {
            return MaterialConverter.stringToMaterial((String)String.valueOf(o));
        }

        public Object serialize(Material material, Class<Material> aClass) {
            return material.name().toLowerCase();
        }
    }).build());
    final ConfigNode<Boolean> bucketFilling = this.node(((ConfigNode.Builder)((ConfigNode.Builder)ConfigNode.builder((String)"portal-creation.bucket-filling", Boolean.class).comment("")).comment("If enabled, water and lava bucket can be used to fill a mvportal.")).defaultValue((Object)true).name("bucket-filling").onSetValue((oldValue, newValue) -> {
        MultiversePortals.bucketFilling = newValue;
    }).build());
    final ListConfigNode<Material> frameMaterials = this.node(((ListConfigNode.Builder)((ListConfigNode.Builder)((ListConfigNode.Builder)((ListConfigNode.Builder)((ListConfigNode.Builder)((ListConfigNode.Builder)ListConfigNode.listBuilder((String)"portal-creation.frame-materials", Material.class).comment("")).comment("The allowed materials used to create the frame of the portal.")).comment("If the list is empty, all materials are allowed.")).defaultValue(ArrayList::new)).name("frame-materials")).itemSerializer((NodeSerializer)new NodeSerializer<Material>(){

        public Material deserialize(Object o, Class<Material> aClass) {
            return MaterialConverter.stringToMaterial((String)String.valueOf(o));
        }

        public Object serialize(Material material, Class<Material> aClass) {
            return material.name().toLowerCase();
        }
    }).onSetValue((oldValue, newValue) -> {
        MultiversePortals.FrameMaterials = newValue;
    })).build());
    final ConfigNode<Boolean> clearOnRemove = this.node(((ConfigNode.Builder)((ConfigNode.Builder)((ConfigNode.Builder)ConfigNode.builder((String)"portal-creation.clear-on-remove", Boolean.class).comment("")).comment("If enabled, nether/end fills will be cleared when the portal is removed.")).comment("This keeps us from leaving behind portal blocks (which would take an unsuspecting player to the nether when trying to use the mvportal)")).defaultValue((Object)false).name("clear-on-remove").aliases(new String[]{"clearonremove"}).onSetValue((oldValue, newValue) -> {
        MultiversePortals.ClearOnRemove = newValue;
    }).build());
    private final ConfigHeaderNode portalUsageHeader = this.node(ConfigHeaderNode.builder((String)"portal-usage").comment("").comment("").build());
    final ConfigNode<Boolean> enforcePortalAccess = this.node(((ConfigNode.Builder)((ConfigNode.Builder)ConfigNode.builder((String)"portal-usage.enforce-portal-access", Boolean.class).comment("If enabled, players will not be able to teleport to mvportals they do not have access to.")).comment("The permission node is: `multiverse.portal.access.PORTALNAME`")).defaultValue((Object)true).name("enforce-portal-access").aliases(new String[]{"enforceportalaccess"}).onSetValue((oldValue, newValue) -> {
        MultiversePortals.EnforcePortalAccess = newValue;
    }).build());
    final ConfigNode<Integer> portalCooldown = this.node(((ConfigNode.Builder)((ConfigNode.Builder)ConfigNode.builder((String)"portal-usage.portal-cooldown", Integer.class).comment("")).comment("The number of seconds a player must wait between using a mvportal.")).defaultValue((Object)1000).name("portal-cooldown").aliases(new String[]{"portalcooldown"}).build());
    final ConfigNode<Boolean> portalsDefaultToNether = this.node(((ConfigNode.Builder)((ConfigNode.Builder)((ConfigNode.Builder)ConfigNode.builder((String)"portal-usage.portals-default-to-nether", Boolean.class).comment("")).comment("If enabled, when a mvportal with nether fill that is unusable, either due to invalid destination or lack of permissions,")).comment("will fallback and behave as a normal nether portal teleporting between the nether world.")).defaultValue((Object)false).name("portals-default-to-nether").aliases(new String[]{"portalsdefaulttonether"}).build());
    final ConfigNode<Boolean> netherAnimation = this.node(((ConfigNode.Builder)((ConfigNode.Builder)((ConfigNode.Builder)ConfigNode.builder((String)"portal-usage.nether-animation", Boolean.class).comment("")).comment("If enabled, the nether blobbing animation will be played before the player is teleported.")).comment("Note: This does not work if the player is in creative mode due to server software limitations.")).defaultValue((Object)true).name("nether-animation").onSetValue((oldValue, newValue) -> {
        MultiversePortals.NetherAnimation = newValue;
    }).build());
    final ConfigNode<Boolean> teleportVehicles = this.node(((ConfigNode.Builder)((ConfigNode.Builder)((ConfigNode.Builder)ConfigNode.builder((String)"portal-usage.teleport-vehicles", Boolean.class).comment("")).comment("If enabled, mvportals will teleport all vehicles along with its passengers when the vehicle enters the portal.")).comment("Vehicles are usually boats, minecarts, pigs and horses.")).defaultValue((Object)false).name("teleport-vehicles").aliases(new String[]{"teleportvehicles"}).onSetValue((oldValue, newValue) -> {
        MultiversePortals.TeleportVehicles = newValue;
    }).build());
    final ConfigNode<Boolean> useOnMove = this.node(((ConfigNode.Builder)((ConfigNode.Builder)((ConfigNode.Builder)ConfigNode.builder((String)"portal-usage.use-on-move", Boolean.class).comment("")).comment("If enabled, player movement will be tracked to determine if the player has entered a portal.")).comment("Disabling this will cause mvportals without nether or end fill to not work.")).defaultValue((Object)true).name("use-on-move").aliases(new String[]{"useonmove"}).onSetValue((oldValue, newValue) -> {
        MultiversePortals.UseOnMove = newValue;
    }).build());
    final ConfigNode<Double> version = this.node(((ConfigNode.Builder)((ConfigNode.Builder)((ConfigNode.Builder)((ConfigNode.Builder)ConfigNode.builder((String)"version", Double.class).comment("")).comment("")).comment("This just signifies the version number so we can see what version of config you have.")).comment("NEVER TOUCH THIS VALUE")).defaultValue((Object)0.0).hidden().build());

    PortalsConfigNodes() {
    }

    NodeGroup getNodes() {
        return this.nodes;
    }

    private <N extends Node> N node(N node) {
        this.nodes.add(node);
        return node;
    }
}

