/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.portals.listeners;

import java.util.ArrayList;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.vehicle.VehicleMoveEvent;
import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.core.destination.DestinationInstance;
import org.mvplugins.multiverse.core.economy.MVEconomist;
import org.mvplugins.multiverse.core.teleportation.AsyncSafetyTeleporter;
import org.mvplugins.multiverse.core.teleportation.PassengerMode;
import org.mvplugins.multiverse.core.teleportation.PassengerModes;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.portals.MVPortal;
import org.mvplugins.multiverse.portals.MultiversePortals;
import org.mvplugins.multiverse.portals.PortalPlayerSession;
import org.mvplugins.multiverse.portals.config.PortalsConfig;
import org.mvplugins.multiverse.portals.enums.MoveType;
import org.mvplugins.multiverse.portals.util.MVPLogging;
import org.mvplugins.multiverse.portals.utils.PortalManager;

@Service
public class MVPVehicleListener
implements Listener {
    private final MultiversePortals plugin;
    private final PortalManager portalManager;
    private final AsyncSafetyTeleporter safetyTeleporter;
    private final PortalsConfig portalsConfig;
    private final MVEconomist economist;

    @Inject
    MVPVehicleListener(@NotNull MultiversePortals plugin, @NotNull PortalManager portalManager, @NotNull AsyncSafetyTeleporter safetyTeleporter, @NotNull PortalsConfig portalsConfig, @NotNull MVEconomist economist) {
        this.plugin = plugin;
        this.portalManager = portalManager;
        this.safetyTeleporter = safetyTeleporter;
        this.portalsConfig = portalsConfig;
        this.economist = economist;
    }

    @EventHandler
    public void vehicleMove(VehicleMoveEvent event) {
        Vehicle vehicle = event.getVehicle();
        ArrayList<Player> playerPassengers = new ArrayList<Player>();
        boolean hasNonPlayers = false;
        for (Object entity : vehicle.getPassengers()) {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                PortalPlayerSession ps = this.plugin.getPortalSession(player);
                ps.setStaleLocation(vehicle.getLocation(), MoveType.VEHICLE_MOVE);
                if (ps.isStaleLocation()) {
                    MVPLogging.finer("Player %s is stale, not teleporting vehicle", player.getName());
                    return;
                }
                playerPassengers.add(player);
                continue;
            }
            hasNonPlayers = true;
        }
        MVPortal portal = this.portalManager.getPortal(vehicle.getLocation());
        if (portal == null) {
            return;
        }
        if (hasNonPlayers && !portal.getTeleportNonPlayers()) {
            MVPLogging.finer("Not teleporting vehicle using %s because it has non-player passengers", portal.getName());
            return;
        }
        if (!portal.isFrameValid(vehicle.getLocation())) {
            MVPLogging.finer("Not teleporting vehicle using %s as the frame is made of an incorrect material.", portal.getName());
            return;
        }
        for (Player player : playerPassengers) {
            if (this.checkPlayerCanUsePortal(portal, player)) continue;
            MVPLogging.finer("Player %s is not allowed to use portal %s, removing them from the vehicle.", player.getName(), portal.getName());
            vehicle.removePassenger((Entity)player);
        }
        DestinationInstance<?, ?> destination = portal.getDestination();
        this.safetyTeleporter.to(destination).checkSafety(portal.getCheckDestinationSafety() && destination.checkTeleportSafety()).passengerMode((PassengerMode)PassengerModes.RETAIN_ALL).teleportSingle((Entity)vehicle).onSuccess(() -> MVPLogging.finer("Successfully teleported vehicle %s using portal %s", vehicle.getName(), portal.getName())).onFailure(failures -> MVPLogging.finer("Failed to teleport vehicle %s using portal %s. Failures: %s", vehicle.getName(), portal.getName(), failures));
    }

    private boolean checkPlayerCanUsePortal(MVPortal portal, Player player) {
        if (this.portalsConfig.getEnforcePortalAccess() && !player.hasPermission(portal.getPermission())) {
            return false;
        }
        boolean shouldPay = false;
        double price = portal.getPrice();
        Material currency = portal.getCurrency();
        if (price != 0.0 && !player.hasPermission(portal.getExempt())) {
            shouldPay = true;
            if (price > 0.0 && !this.economist.isPlayerWealthyEnough(player, price, currency)) {
                player.sendMessage(this.economist.getNSFMessage(currency, "You need " + this.economist.formatPrice(price, currency) + " to enter the " + portal.getName() + " portal."));
                return false;
            }
        }
        if (shouldPay) {
            if (price < 0.0) {
                this.economist.deposit(player, -price, currency);
            } else {
                this.economist.withdraw(player, price, currency);
            }
        }
        return true;
    }
}

